/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.AttachmentRoutingPolicyAssociationSummary;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentRoutingPolicyAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentRoutingPolicyAssociationsResponse;

public class ListAttachmentRoutingPolicyAssociationsIterable
implements SdkIterable<ListAttachmentRoutingPolicyAssociationsResponse> {
    private final NetworkManagerClient client;
    private final ListAttachmentRoutingPolicyAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachmentRoutingPolicyAssociationsIterable(NetworkManagerClient client, ListAttachmentRoutingPolicyAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttachmentRoutingPolicyAssociationsResponseFetcher();
    }

    public Iterator<ListAttachmentRoutingPolicyAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttachmentRoutingPolicyAssociationSummary> attachmentRoutingPolicyAssociations() {
        Function<ListAttachmentRoutingPolicyAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachmentRoutingPolicyAssociations() != null) {
                return response.attachmentRoutingPolicyAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachmentRoutingPolicyAssociationsResponseFetcher
    implements SyncPageFetcher<ListAttachmentRoutingPolicyAssociationsResponse> {
        private ListAttachmentRoutingPolicyAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachmentRoutingPolicyAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttachmentRoutingPolicyAssociationsResponse nextPage(ListAttachmentRoutingPolicyAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAttachmentRoutingPolicyAssociationsIterable.this.client.listAttachmentRoutingPolicyAssociations(ListAttachmentRoutingPolicyAssociationsIterable.this.firstRequest);
            }
            return ListAttachmentRoutingPolicyAssociationsIterable.this.client.listAttachmentRoutingPolicyAssociations((ListAttachmentRoutingPolicyAssociationsRequest)((Object)ListAttachmentRoutingPolicyAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

