/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.Attachment;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse;

public class ListAttachmentsPublisher
implements SdkPublisher<ListAttachmentsResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachmentsPublisher(NetworkManagerAsyncClient client, ListAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachmentsPublisher(NetworkManagerAsyncClient client, ListAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Attachment> attachments() {
        Function<ListAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachments() != null) {
                return response.attachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttachmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttachmentsResponseFetcher
    implements AsyncPageFetcher<ListAttachmentsResponse> {
        private ListAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttachmentsResponse> nextPage(ListAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListAttachmentsPublisher.this.client.listAttachments(ListAttachmentsPublisher.this.firstRequest);
            }
            return ListAttachmentsPublisher.this.client.listAttachments((ListAttachmentsRequest)((Object)ListAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

