/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPrefixListAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPrefixListAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.PrefixListAssociation;

public class ListCoreNetworkPrefixListAssociationsPublisher
implements SdkPublisher<ListCoreNetworkPrefixListAssociationsResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListCoreNetworkPrefixListAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoreNetworkPrefixListAssociationsPublisher(NetworkManagerAsyncClient client, ListCoreNetworkPrefixListAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoreNetworkPrefixListAssociationsPublisher(NetworkManagerAsyncClient client, ListCoreNetworkPrefixListAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoreNetworkPrefixListAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoreNetworkPrefixListAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrefixListAssociation> prefixListAssociations() {
        Function<ListCoreNetworkPrefixListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixListAssociations() != null) {
                return response.prefixListAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoreNetworkPrefixListAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoreNetworkPrefixListAssociationsResponseFetcher
    implements AsyncPageFetcher<ListCoreNetworkPrefixListAssociationsResponse> {
        private ListCoreNetworkPrefixListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworkPrefixListAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoreNetworkPrefixListAssociationsResponse> nextPage(ListCoreNetworkPrefixListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworkPrefixListAssociationsPublisher.this.client.listCoreNetworkPrefixListAssociations(ListCoreNetworkPrefixListAssociationsPublisher.this.firstRequest);
            }
            return ListCoreNetworkPrefixListAssociationsPublisher.this.client.listCoreNetworkPrefixListAssociations((ListCoreNetworkPrefixListAssociationsRequest)((Object)ListCoreNetworkPrefixListAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

