/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListPeeringsResponse;
import software.amazon.awssdk.services.networkmanager.model.Peering;

public class ListPeeringsIterable
implements SdkIterable<ListPeeringsResponse> {
    private final NetworkManagerClient client;
    private final ListPeeringsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPeeringsIterable(NetworkManagerClient client, ListPeeringsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPeeringsResponseFetcher();
    }

    public Iterator<ListPeeringsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Peering> peerings() {
        Function<ListPeeringsResponse, Iterator> getIterator = response -> {
            if (response != null && response.peerings() != null) {
                return response.peerings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPeeringsResponseFetcher
    implements SyncPageFetcher<ListPeeringsResponse> {
        private ListPeeringsResponseFetcher() {
        }

        public boolean hasNextPage(ListPeeringsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPeeringsResponse nextPage(ListPeeringsResponse previousPage) {
            if (previousPage == null) {
                return ListPeeringsIterable.this.client.listPeerings(ListPeeringsIterable.this.firstRequest);
            }
            return ListPeeringsIterable.this.client.listPeerings((ListPeeringsRequest)((Object)ListPeeringsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

