/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.AggregationKey;
import software.amazon.awssdk.services.notifications.model.AggregationKeysCopier;
import software.amazon.awssdk.services.notifications.model.SummarizationDimensionOverview;
import software.amazon.awssdk.services.notifications.model.SummarizationDimensionOverviewsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationSummary> {
    private static final SdkField<Integer> EVENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("eventCount").getter(AggregationSummary.getter(AggregationSummary::eventCount)).setter(AggregationSummary.setter(Builder::eventCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventCount").build()}).build();
    private static final SdkField<List<AggregationKey>> AGGREGATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregatedBy").getter(AggregationSummary.getter(AggregationSummary::aggregatedBy)).setter(AggregationSummary.setter(Builder::aggregatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SummarizationDimensionOverview> AGGREGATED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregatedAccounts").getter(AggregationSummary.getter(AggregationSummary::aggregatedAccounts)).setter(AggregationSummary.setter(Builder::aggregatedAccounts)).constructor(SummarizationDimensionOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedAccounts").build()}).build();
    private static final SdkField<SummarizationDimensionOverview> AGGREGATED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregatedRegions").getter(AggregationSummary.getter(AggregationSummary::aggregatedRegions)).setter(AggregationSummary.setter(Builder::aggregatedRegions)).constructor(SummarizationDimensionOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedRegions").build()}).build();
    private static final SdkField<SummarizationDimensionOverview> AGGREGATED_ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregatedOrganizationalUnits").getter(AggregationSummary.getter(AggregationSummary::aggregatedOrganizationalUnits)).setter(AggregationSummary.setter(Builder::aggregatedOrganizationalUnits)).constructor(SummarizationDimensionOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedOrganizationalUnits").build()}).build();
    private static final SdkField<List<SummarizationDimensionOverview>> ADDITIONAL_SUMMARIZATION_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalSummarizationDimensions").getter(AggregationSummary.getter(AggregationSummary::additionalSummarizationDimensions)).setter(AggregationSummary.setter(Builder::additionalSummarizationDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalSummarizationDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SummarizationDimensionOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_COUNT_FIELD, AGGREGATED_BY_FIELD, AGGREGATED_ACCOUNTS_FIELD, AGGREGATED_REGIONS_FIELD, AGGREGATED_ORGANIZATIONAL_UNITS_FIELD, ADDITIONAL_SUMMARIZATION_DIMENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer eventCount;
    private final List<AggregationKey> aggregatedBy;
    private final SummarizationDimensionOverview aggregatedAccounts;
    private final SummarizationDimensionOverview aggregatedRegions;
    private final SummarizationDimensionOverview aggregatedOrganizationalUnits;
    private final List<SummarizationDimensionOverview> additionalSummarizationDimensions;

    private AggregationSummary(BuilderImpl builder) {
        this.eventCount = builder.eventCount;
        this.aggregatedBy = builder.aggregatedBy;
        this.aggregatedAccounts = builder.aggregatedAccounts;
        this.aggregatedRegions = builder.aggregatedRegions;
        this.aggregatedOrganizationalUnits = builder.aggregatedOrganizationalUnits;
        this.additionalSummarizationDimensions = builder.additionalSummarizationDimensions;
    }

    public final Integer eventCount() {
        return this.eventCount;
    }

    public final boolean hasAggregatedBy() {
        return this.aggregatedBy != null && !(this.aggregatedBy instanceof SdkAutoConstructList);
    }

    public final List<AggregationKey> aggregatedBy() {
        return this.aggregatedBy;
    }

    public final SummarizationDimensionOverview aggregatedAccounts() {
        return this.aggregatedAccounts;
    }

    public final SummarizationDimensionOverview aggregatedRegions() {
        return this.aggregatedRegions;
    }

    public final SummarizationDimensionOverview aggregatedOrganizationalUnits() {
        return this.aggregatedOrganizationalUnits;
    }

    public final boolean hasAdditionalSummarizationDimensions() {
        return this.additionalSummarizationDimensions != null && !(this.additionalSummarizationDimensions instanceof SdkAutoConstructList);
    }

    public final List<SummarizationDimensionOverview> additionalSummarizationDimensions() {
        return this.additionalSummarizationDimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedBy() ? this.aggregatedBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedRegions());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedOrganizationalUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalSummarizationDimensions() ? this.additionalSummarizationDimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationSummary)) {
            return false;
        }
        AggregationSummary other = (AggregationSummary)obj;
        return Objects.equals(this.eventCount(), other.eventCount()) && this.hasAggregatedBy() == other.hasAggregatedBy() && Objects.equals(this.aggregatedBy(), other.aggregatedBy()) && Objects.equals(this.aggregatedAccounts(), other.aggregatedAccounts()) && Objects.equals(this.aggregatedRegions(), other.aggregatedRegions()) && Objects.equals(this.aggregatedOrganizationalUnits(), other.aggregatedOrganizationalUnits()) && this.hasAdditionalSummarizationDimensions() == other.hasAdditionalSummarizationDimensions() && Objects.equals(this.additionalSummarizationDimensions(), other.additionalSummarizationDimensions());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationSummary").add("EventCount", (Object)this.eventCount()).add("AggregatedBy", this.hasAggregatedBy() ? this.aggregatedBy() : null).add("AggregatedAccounts", (Object)this.aggregatedAccounts()).add("AggregatedRegions", (Object)this.aggregatedRegions()).add("AggregatedOrganizationalUnits", (Object)this.aggregatedOrganizationalUnits()).add("AdditionalSummarizationDimensions", this.hasAdditionalSummarizationDimensions() ? this.additionalSummarizationDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventCount": {
                return Optional.ofNullable(clazz.cast(this.eventCount()));
            }
            case "aggregatedBy": {
                return Optional.ofNullable(clazz.cast(this.aggregatedBy()));
            }
            case "aggregatedAccounts": {
                return Optional.ofNullable(clazz.cast(this.aggregatedAccounts()));
            }
            case "aggregatedRegions": {
                return Optional.ofNullable(clazz.cast(this.aggregatedRegions()));
            }
            case "aggregatedOrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.aggregatedOrganizationalUnits()));
            }
            case "additionalSummarizationDimensions": {
                return Optional.ofNullable(clazz.cast(this.additionalSummarizationDimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventCount", EVENT_COUNT_FIELD);
        map.put("aggregatedBy", AGGREGATED_BY_FIELD);
        map.put("aggregatedAccounts", AGGREGATED_ACCOUNTS_FIELD);
        map.put("aggregatedRegions", AGGREGATED_REGIONS_FIELD);
        map.put("aggregatedOrganizationalUnits", AGGREGATED_ORGANIZATIONAL_UNITS_FIELD);
        map.put("additionalSummarizationDimensions", ADDITIONAL_SUMMARIZATION_DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationSummary, T> g) {
        return obj -> g.apply((AggregationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer eventCount;
        private List<AggregationKey> aggregatedBy = DefaultSdkAutoConstructList.getInstance();
        private SummarizationDimensionOverview aggregatedAccounts;
        private SummarizationDimensionOverview aggregatedRegions;
        private SummarizationDimensionOverview aggregatedOrganizationalUnits;
        private List<SummarizationDimensionOverview> additionalSummarizationDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationSummary model) {
            this.eventCount(model.eventCount);
            this.aggregatedBy(model.aggregatedBy);
            this.aggregatedAccounts(model.aggregatedAccounts);
            this.aggregatedRegions(model.aggregatedRegions);
            this.aggregatedOrganizationalUnits(model.aggregatedOrganizationalUnits);
            this.additionalSummarizationDimensions(model.additionalSummarizationDimensions);
        }

        public final Integer getEventCount() {
            return this.eventCount;
        }

        public final void setEventCount(Integer eventCount) {
            this.eventCount = eventCount;
        }

        @Override
        public final Builder eventCount(Integer eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        public final List<AggregationKey.Builder> getAggregatedBy() {
            List<AggregationKey.Builder> result = AggregationKeysCopier.copyToBuilder(this.aggregatedBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedBy(Collection<AggregationKey.BuilderImpl> aggregatedBy) {
            this.aggregatedBy = AggregationKeysCopier.copyFromBuilder(aggregatedBy);
        }

        @Override
        public final Builder aggregatedBy(Collection<AggregationKey> aggregatedBy) {
            this.aggregatedBy = AggregationKeysCopier.copy(aggregatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedBy(AggregationKey ... aggregatedBy) {
            this.aggregatedBy(Arrays.asList(aggregatedBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedBy(Consumer<AggregationKey.Builder> ... aggregatedBy) {
            this.aggregatedBy(Stream.of(aggregatedBy).map(c -> (AggregationKey)((AggregationKey.Builder)AggregationKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SummarizationDimensionOverview.Builder getAggregatedAccounts() {
            return this.aggregatedAccounts != null ? this.aggregatedAccounts.toBuilder() : null;
        }

        public final void setAggregatedAccounts(SummarizationDimensionOverview.BuilderImpl aggregatedAccounts) {
            this.aggregatedAccounts = aggregatedAccounts != null ? aggregatedAccounts.build() : null;
        }

        @Override
        public final Builder aggregatedAccounts(SummarizationDimensionOverview aggregatedAccounts) {
            this.aggregatedAccounts = aggregatedAccounts;
            return this;
        }

        public final SummarizationDimensionOverview.Builder getAggregatedRegions() {
            return this.aggregatedRegions != null ? this.aggregatedRegions.toBuilder() : null;
        }

        public final void setAggregatedRegions(SummarizationDimensionOverview.BuilderImpl aggregatedRegions) {
            this.aggregatedRegions = aggregatedRegions != null ? aggregatedRegions.build() : null;
        }

        @Override
        public final Builder aggregatedRegions(SummarizationDimensionOverview aggregatedRegions) {
            this.aggregatedRegions = aggregatedRegions;
            return this;
        }

        public final SummarizationDimensionOverview.Builder getAggregatedOrganizationalUnits() {
            return this.aggregatedOrganizationalUnits != null ? this.aggregatedOrganizationalUnits.toBuilder() : null;
        }

        public final void setAggregatedOrganizationalUnits(SummarizationDimensionOverview.BuilderImpl aggregatedOrganizationalUnits) {
            this.aggregatedOrganizationalUnits = aggregatedOrganizationalUnits != null ? aggregatedOrganizationalUnits.build() : null;
        }

        @Override
        public final Builder aggregatedOrganizationalUnits(SummarizationDimensionOverview aggregatedOrganizationalUnits) {
            this.aggregatedOrganizationalUnits = aggregatedOrganizationalUnits;
            return this;
        }

        public final List<SummarizationDimensionOverview.Builder> getAdditionalSummarizationDimensions() {
            List<SummarizationDimensionOverview.Builder> result = SummarizationDimensionOverviewsCopier.copyToBuilder(this.additionalSummarizationDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalSummarizationDimensions(Collection<SummarizationDimensionOverview.BuilderImpl> additionalSummarizationDimensions) {
            this.additionalSummarizationDimensions = SummarizationDimensionOverviewsCopier.copyFromBuilder(additionalSummarizationDimensions);
        }

        @Override
        public final Builder additionalSummarizationDimensions(Collection<SummarizationDimensionOverview> additionalSummarizationDimensions) {
            this.additionalSummarizationDimensions = SummarizationDimensionOverviewsCopier.copy(additionalSummarizationDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSummarizationDimensions(SummarizationDimensionOverview ... additionalSummarizationDimensions) {
            this.additionalSummarizationDimensions(Arrays.asList(additionalSummarizationDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSummarizationDimensions(Consumer<SummarizationDimensionOverview.Builder> ... additionalSummarizationDimensions) {
            this.additionalSummarizationDimensions(Stream.of(additionalSummarizationDimensions).map(c -> (SummarizationDimensionOverview)((SummarizationDimensionOverview.Builder)SummarizationDimensionOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AggregationSummary build() {
            return new AggregationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationSummary> {
        public Builder eventCount(Integer var1);

        public Builder aggregatedBy(Collection<AggregationKey> var1);

        public Builder aggregatedBy(AggregationKey ... var1);

        public Builder aggregatedBy(Consumer<AggregationKey.Builder> ... var1);

        public Builder aggregatedAccounts(SummarizationDimensionOverview var1);

        default public Builder aggregatedAccounts(Consumer<SummarizationDimensionOverview.Builder> aggregatedAccounts) {
            return this.aggregatedAccounts((SummarizationDimensionOverview)((SummarizationDimensionOverview.Builder)SummarizationDimensionOverview.builder().applyMutation(aggregatedAccounts)).build());
        }

        public Builder aggregatedRegions(SummarizationDimensionOverview var1);

        default public Builder aggregatedRegions(Consumer<SummarizationDimensionOverview.Builder> aggregatedRegions) {
            return this.aggregatedRegions((SummarizationDimensionOverview)((SummarizationDimensionOverview.Builder)SummarizationDimensionOverview.builder().applyMutation(aggregatedRegions)).build());
        }

        public Builder aggregatedOrganizationalUnits(SummarizationDimensionOverview var1);

        default public Builder aggregatedOrganizationalUnits(Consumer<SummarizationDimensionOverview.Builder> aggregatedOrganizationalUnits) {
            return this.aggregatedOrganizationalUnits((SummarizationDimensionOverview)((SummarizationDimensionOverview.Builder)SummarizationDimensionOverview.builder().applyMutation(aggregatedOrganizationalUnits)).build());
        }

        public Builder additionalSummarizationDimensions(Collection<SummarizationDimensionOverview> var1);

        public Builder additionalSummarizationDimensions(SummarizationDimensionOverview ... var1);

        public Builder additionalSummarizationDimensions(Consumer<SummarizationDimensionOverview.Builder> ... var1);
    }
}

