/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.MediaElementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaElement> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaId").getter(MediaElement.getter(MediaElement::mediaId)).setter(MediaElement.setter(Builder::mediaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(MediaElement.getter(MediaElement::typeAsString)).setter(MediaElement.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(MediaElement.getter(MediaElement::url)).setter(MediaElement.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> CAPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caption").getter(MediaElement.getter(MediaElement::caption)).setter(MediaElement.setter(Builder::caption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD, TYPE_FIELD, URL_FIELD, CAPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaId;
    private final String type;
    private final String url;
    private final String caption;

    private MediaElement(BuilderImpl builder) {
        this.mediaId = builder.mediaId;
        this.type = builder.type;
        this.url = builder.url;
        this.caption = builder.caption;
    }

    public final String mediaId() {
        return this.mediaId;
    }

    public final MediaElementType type() {
        return MediaElementType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String url() {
        return this.url;
    }

    public final String caption() {
        return this.caption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.caption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaElement)) {
            return false;
        }
        MediaElement other = (MediaElement)obj;
        return Objects.equals(this.mediaId(), other.mediaId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.caption(), other.caption());
    }

    public final String toString() {
        return ToString.builder((String)"MediaElement").add("MediaId", (Object)this.mediaId()).add("Type", (Object)this.typeAsString()).add("Url", (Object)this.url()).add("Caption", (Object)this.caption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mediaId": {
                return Optional.ofNullable(clazz.cast(this.mediaId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "caption": {
                return Optional.ofNullable(clazz.cast(this.caption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("url", URL_FIELD);
        map.put("caption", CAPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaElement, T> g) {
        return obj -> g.apply((MediaElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaId;
        private String type;
        private String url;
        private String caption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaElement model) {
            this.mediaId(model.mediaId);
            this.type(model.type);
            this.url(model.url);
            this.caption(model.caption);
        }

        public final String getMediaId() {
            return this.mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MediaElementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getCaption() {
            return this.caption;
        }

        public final void setCaption(String caption) {
            this.caption = caption;
        }

        @Override
        public final Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public MediaElement build() {
            return new MediaElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaElement> {
        public Builder mediaId(String var1);

        public Builder type(String var1);

        public Builder type(MediaElementType var1);

        public Builder url(String var1);

        public Builder caption(String var1);
    }
}

