/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.SupportedAwsIntegration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateIamRoleToResourceRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, AssociateIamRoleToResourceRequest> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleArn").getter(AssociateIamRoleToResourceRequest.getter(AssociateIamRoleToResourceRequest::iamRoleArn)).setter(AssociateIamRoleToResourceRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final SdkField<String> AWS_INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsIntegration").getter(AssociateIamRoleToResourceRequest.getter(AssociateIamRoleToResourceRequest::awsIntegrationAsString)).setter(AssociateIamRoleToResourceRequest.setter(Builder::awsIntegration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIntegration").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(AssociateIamRoleToResourceRequest.getter(AssociateIamRoleToResourceRequest::resourceArn)).setter(AssociateIamRoleToResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD, AWS_INTEGRATION_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateIamRoleToResourceRequest.memberNameToFieldInitializer();
    private final String iamRoleArn;
    private final String awsIntegration;
    private final String resourceArn;

    private AssociateIamRoleToResourceRequest(BuilderImpl builder) {
        super(builder);
        this.iamRoleArn = builder.iamRoleArn;
        this.awsIntegration = builder.awsIntegration;
        this.resourceArn = builder.resourceArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final SupportedAwsIntegration awsIntegration() {
        return SupportedAwsIntegration.fromValue(this.awsIntegration);
    }

    public final String awsIntegrationAsString() {
        return this.awsIntegration;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIntegrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateIamRoleToResourceRequest)) {
            return false;
        }
        AssociateIamRoleToResourceRequest other = (AssociateIamRoleToResourceRequest)((Object)obj);
        return Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.awsIntegrationAsString(), other.awsIntegrationAsString()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateIamRoleToResourceRequest").add("IamRoleArn", (Object)this.iamRoleArn()).add("AwsIntegration", (Object)this.awsIntegrationAsString()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "awsIntegration": {
                return Optional.ofNullable(clazz.cast(this.awsIntegrationAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("awsIntegration", AWS_INTEGRATION_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateIamRoleToResourceRequest, T> g) {
        return obj -> g.apply((AssociateIamRoleToResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String iamRoleArn;
        private String awsIntegration;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateIamRoleToResourceRequest model) {
            super(model);
            this.iamRoleArn(model.iamRoleArn);
            this.awsIntegration(model.awsIntegration);
            this.resourceArn(model.resourceArn);
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getAwsIntegration() {
            return this.awsIntegration;
        }

        public final void setAwsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
        }

        @Override
        public final Builder awsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
            return this;
        }

        @Override
        public final Builder awsIntegration(SupportedAwsIntegration awsIntegration) {
            this.awsIntegration(awsIntegration == null ? null : awsIntegration.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateIamRoleToResourceRequest build() {
            return new AssociateIamRoleToResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateIamRoleToResourceRequest> {
        public Builder iamRoleArn(String var1);

        public Builder awsIntegration(String var1);

        public Builder awsIntegration(SupportedAwsIntegration var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

