/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutonomousVirtualMachineSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutonomousVirtualMachineSummary> {
    private static final SdkField<String> AUTONOMOUS_VIRTUAL_MACHINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autonomousVirtualMachineId").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::autonomousVirtualMachineId)).setter(AutonomousVirtualMachineSummary.setter(Builder::autonomousVirtualMachineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousVirtualMachineId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::statusAsString)).setter(AutonomousVirtualMachineSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::statusReason)).setter(AutonomousVirtualMachineSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> VM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmName").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::vmName)).setter(AutonomousVirtualMachineSummary.setter(Builder::vmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmName").build()}).build();
    private static final SdkField<String> DB_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbServerId").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::dbServerId)).setter(AutonomousVirtualMachineSummary.setter(Builder::dbServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerId").build()}).build();
    private static final SdkField<String> DB_SERVER_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbServerDisplayName").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::dbServerDisplayName)).setter(AutonomousVirtualMachineSummary.setter(Builder::dbServerDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerDisplayName").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCount").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::cpuCoreCount)).setter(AutonomousVirtualMachineSummary.setter(Builder::cpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::memorySizeInGBs)).setter(AutonomousVirtualMachineSummary.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::dbNodeStorageSizeInGBs)).setter(AutonomousVirtualMachineSummary.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<String> CLIENT_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientIpAddress").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::clientIpAddress)).setter(AutonomousVirtualMachineSummary.setter(Builder::clientIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIpAddress").build()}).build();
    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudAutonomousVmClusterId").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::cloudAutonomousVmClusterId)).setter(AutonomousVirtualMachineSummary.setter(Builder::cloudAutonomousVmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterId").build()}).build();
    private static final SdkField<String> OCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocid").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::ocid)).setter(AutonomousVirtualMachineSummary.setter(Builder::ocid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(AutonomousVirtualMachineSummary.getter(AutonomousVirtualMachineSummary::ociResourceAnchorName)).setter(AutonomousVirtualMachineSummary.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTONOMOUS_VIRTUAL_MACHINE_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, VM_NAME_FIELD, DB_SERVER_ID_FIELD, DB_SERVER_DISPLAY_NAME_FIELD, CPU_CORE_COUNT_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, CLIENT_IP_ADDRESS_FIELD, CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD, OCID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutonomousVirtualMachineSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String autonomousVirtualMachineId;
    private final String status;
    private final String statusReason;
    private final String vmName;
    private final String dbServerId;
    private final String dbServerDisplayName;
    private final Integer cpuCoreCount;
    private final Integer memorySizeInGBs;
    private final Integer dbNodeStorageSizeInGBs;
    private final String clientIpAddress;
    private final String cloudAutonomousVmClusterId;
    private final String ocid;
    private final String ociResourceAnchorName;

    private AutonomousVirtualMachineSummary(BuilderImpl builder) {
        this.autonomousVirtualMachineId = builder.autonomousVirtualMachineId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.vmName = builder.vmName;
        this.dbServerId = builder.dbServerId;
        this.dbServerDisplayName = builder.dbServerDisplayName;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.clientIpAddress = builder.clientIpAddress;
        this.cloudAutonomousVmClusterId = builder.cloudAutonomousVmClusterId;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
    }

    public final String autonomousVirtualMachineId() {
        return this.autonomousVirtualMachineId;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String vmName() {
        return this.vmName;
    }

    public final String dbServerId() {
        return this.dbServerId;
    }

    public final String dbServerDisplayName() {
        return this.dbServerDisplayName;
    }

    public final Integer cpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final String clientIpAddress() {
        return this.clientIpAddress;
    }

    public final String cloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public final String ocid() {
        return this.ocid;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autonomousVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbServerDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudAutonomousVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutonomousVirtualMachineSummary)) {
            return false;
        }
        AutonomousVirtualMachineSummary other = (AutonomousVirtualMachineSummary)obj;
        return Objects.equals(this.autonomousVirtualMachineId(), other.autonomousVirtualMachineId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.vmName(), other.vmName()) && Objects.equals(this.dbServerId(), other.dbServerId()) && Objects.equals(this.dbServerDisplayName(), other.dbServerDisplayName()) && Objects.equals(this.cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && Objects.equals(this.clientIpAddress(), other.clientIpAddress()) && Objects.equals(this.cloudAutonomousVmClusterId(), other.cloudAutonomousVmClusterId()) && Objects.equals(this.ocid(), other.ocid()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName());
    }

    public final String toString() {
        return ToString.builder((String)"AutonomousVirtualMachineSummary").add("AutonomousVirtualMachineId", (Object)this.autonomousVirtualMachineId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("VmName", (Object)this.vmName()).add("DbServerId", (Object)this.dbServerId()).add("DbServerDisplayName", (Object)this.dbServerDisplayName()).add("CpuCoreCount", (Object)this.cpuCoreCount()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("ClientIpAddress", (Object)this.clientIpAddress()).add("CloudAutonomousVmClusterId", (Object)this.cloudAutonomousVmClusterId()).add("Ocid", (Object)this.ocid()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autonomousVirtualMachineId": {
                return Optional.ofNullable(clazz.cast(this.autonomousVirtualMachineId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "vmName": {
                return Optional.ofNullable(clazz.cast(this.vmName()));
            }
            case "dbServerId": {
                return Optional.ofNullable(clazz.cast(this.dbServerId()));
            }
            case "dbServerDisplayName": {
                return Optional.ofNullable(clazz.cast(this.dbServerDisplayName()));
            }
            case "cpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCount()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "clientIpAddress": {
                return Optional.ofNullable(clazz.cast(this.clientIpAddress()));
            }
            case "cloudAutonomousVmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudAutonomousVmClusterId()));
            }
            case "ocid": {
                return Optional.ofNullable(clazz.cast(this.ocid()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autonomousVirtualMachineId", AUTONOMOUS_VIRTUAL_MACHINE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("vmName", VM_NAME_FIELD);
        map.put("dbServerId", DB_SERVER_ID_FIELD);
        map.put("dbServerDisplayName", DB_SERVER_DISPLAY_NAME_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("clientIpAddress", CLIENT_IP_ADDRESS_FIELD);
        map.put("cloudAutonomousVmClusterId", CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutonomousVirtualMachineSummary, T> g) {
        return obj -> g.apply((AutonomousVirtualMachineSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autonomousVirtualMachineId;
        private String status;
        private String statusReason;
        private String vmName;
        private String dbServerId;
        private String dbServerDisplayName;
        private Integer cpuCoreCount;
        private Integer memorySizeInGBs;
        private Integer dbNodeStorageSizeInGBs;
        private String clientIpAddress;
        private String cloudAutonomousVmClusterId;
        private String ocid;
        private String ociResourceAnchorName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutonomousVirtualMachineSummary model) {
            this.autonomousVirtualMachineId(model.autonomousVirtualMachineId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.vmName(model.vmName);
            this.dbServerId(model.dbServerId);
            this.dbServerDisplayName(model.dbServerDisplayName);
            this.cpuCoreCount(model.cpuCoreCount);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.clientIpAddress(model.clientIpAddress);
            this.cloudAutonomousVmClusterId(model.cloudAutonomousVmClusterId);
            this.ocid(model.ocid);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
        }

        public final String getAutonomousVirtualMachineId() {
            return this.autonomousVirtualMachineId;
        }

        public final void setAutonomousVirtualMachineId(String autonomousVirtualMachineId) {
            this.autonomousVirtualMachineId = autonomousVirtualMachineId;
        }

        @Override
        public final Builder autonomousVirtualMachineId(String autonomousVirtualMachineId) {
            this.autonomousVirtualMachineId = autonomousVirtualMachineId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getVmName() {
            return this.vmName;
        }

        public final void setVmName(String vmName) {
            this.vmName = vmName;
        }

        @Override
        public final Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public final String getDbServerId() {
            return this.dbServerId;
        }

        public final void setDbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
        }

        @Override
        public final Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            return this;
        }

        public final String getDbServerDisplayName() {
            return this.dbServerDisplayName;
        }

        public final void setDbServerDisplayName(String dbServerDisplayName) {
            this.dbServerDisplayName = dbServerDisplayName;
        }

        @Override
        public final Builder dbServerDisplayName(String dbServerDisplayName) {
            this.dbServerDisplayName = dbServerDisplayName;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final String getClientIpAddress() {
            return this.clientIpAddress;
        }

        public final void setClientIpAddress(String clientIpAddress) {
            this.clientIpAddress = clientIpAddress;
        }

        @Override
        public final Builder clientIpAddress(String clientIpAddress) {
            this.clientIpAddress = clientIpAddress;
            return this;
        }

        public final String getCloudAutonomousVmClusterId() {
            return this.cloudAutonomousVmClusterId;
        }

        public final void setCloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        }

        @Override
        public final Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public final String getOcid() {
            return this.ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public AutonomousVirtualMachineSummary build() {
            return new AutonomousVirtualMachineSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutonomousVirtualMachineSummary> {
        public Builder autonomousVirtualMachineId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder vmName(String var1);

        public Builder dbServerId(String var1);

        public Builder dbServerDisplayName(String var1);

        public Builder cpuCoreCount(Integer var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder clientIpAddress(String var1);

        public Builder cloudAutonomousVmClusterId(String var1);

        public Builder ocid(String var1);

        public Builder ociResourceAnchorName(String var1);
    }
}

