/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureListCopier;
import software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCloudExadataInfrastructuresResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListCloudExadataInfrastructuresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCloudExadataInfrastructuresResponse.getter(ListCloudExadataInfrastructuresResponse::nextToken)).setter(ListCloudExadataInfrastructuresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CloudExadataInfrastructureSummary>> CLOUD_EXADATA_INFRASTRUCTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cloudExadataInfrastructures").getter(ListCloudExadataInfrastructuresResponse.getter(ListCloudExadataInfrastructuresResponse::cloudExadataInfrastructures)).setter(ListCloudExadataInfrastructuresResponse.setter(Builder::cloudExadataInfrastructures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudExadataInfrastructureSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLOUD_EXADATA_INFRASTRUCTURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCloudExadataInfrastructuresResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CloudExadataInfrastructureSummary> cloudExadataInfrastructures;

    private ListCloudExadataInfrastructuresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cloudExadataInfrastructures = builder.cloudExadataInfrastructures;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCloudExadataInfrastructures() {
        return this.cloudExadataInfrastructures != null && !(this.cloudExadataInfrastructures instanceof SdkAutoConstructList);
    }

    public final List<CloudExadataInfrastructureSummary> cloudExadataInfrastructures() {
        return this.cloudExadataInfrastructures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudExadataInfrastructures() ? this.cloudExadataInfrastructures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudExadataInfrastructuresResponse)) {
            return false;
        }
        ListCloudExadataInfrastructuresResponse other = (ListCloudExadataInfrastructuresResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCloudExadataInfrastructures() == other.hasCloudExadataInfrastructures() && Objects.equals(this.cloudExadataInfrastructures(), other.cloudExadataInfrastructures());
    }

    public final String toString() {
        return ToString.builder((String)"ListCloudExadataInfrastructuresResponse").add("NextToken", (Object)this.nextToken()).add("CloudExadataInfrastructures", this.hasCloudExadataInfrastructures() ? this.cloudExadataInfrastructures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "cloudExadataInfrastructures": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("cloudExadataInfrastructures", CLOUD_EXADATA_INFRASTRUCTURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudExadataInfrastructuresResponse, T> g) {
        return obj -> g.apply((ListCloudExadataInfrastructuresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CloudExadataInfrastructureSummary> cloudExadataInfrastructures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudExadataInfrastructuresResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cloudExadataInfrastructures(model.cloudExadataInfrastructures);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CloudExadataInfrastructureSummary.Builder> getCloudExadataInfrastructures() {
            List<CloudExadataInfrastructureSummary.Builder> result = CloudExadataInfrastructureListCopier.copyToBuilder(this.cloudExadataInfrastructures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudExadataInfrastructures(Collection<CloudExadataInfrastructureSummary.BuilderImpl> cloudExadataInfrastructures) {
            this.cloudExadataInfrastructures = CloudExadataInfrastructureListCopier.copyFromBuilder(cloudExadataInfrastructures);
        }

        @Override
        public final Builder cloudExadataInfrastructures(Collection<CloudExadataInfrastructureSummary> cloudExadataInfrastructures) {
            this.cloudExadataInfrastructures = CloudExadataInfrastructureListCopier.copy(cloudExadataInfrastructures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudExadataInfrastructures(CloudExadataInfrastructureSummary ... cloudExadataInfrastructures) {
            this.cloudExadataInfrastructures(Arrays.asList(cloudExadataInfrastructures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudExadataInfrastructures(Consumer<CloudExadataInfrastructureSummary.Builder> ... cloudExadataInfrastructures) {
            this.cloudExadataInfrastructures(Stream.of(cloudExadataInfrastructures).map(c -> (CloudExadataInfrastructureSummary)((CloudExadataInfrastructureSummary.Builder)CloudExadataInfrastructureSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCloudExadataInfrastructuresResponse build() {
            return new ListCloudExadataInfrastructuresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCloudExadataInfrastructuresResponse> {
        public Builder nextToken(String var1);

        public Builder cloudExadataInfrastructures(Collection<CloudExadataInfrastructureSummary> var1);

        public Builder cloudExadataInfrastructures(CloudExadataInfrastructureSummary ... var1);

        public Builder cloudExadataInfrastructures(Consumer<CloudExadataInfrastructureSummary.Builder> ... var1);
    }
}

