/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportedAwsIntegration {
    KMS_TDE("KmsTde"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportedAwsIntegration> VALUE_MAP;
    private final String value;

    private SupportedAwsIntegration(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportedAwsIntegration fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportedAwsIntegration> knownValues() {
        EnumSet<SupportedAwsIntegration> knownValues = EnumSet.allOf(SupportedAwsIntegration.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportedAwsIntegration.class, SupportedAwsIntegration::toString);
    }
}

