/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.DbSystemShapeSummary;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse;

public class ListDbSystemShapesPublisher
implements SdkPublisher<ListDbSystemShapesResponse> {
    private final OdbAsyncClient client;
    private final ListDbSystemShapesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbSystemShapesPublisher(OdbAsyncClient client, ListDbSystemShapesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbSystemShapesPublisher(OdbAsyncClient client, ListDbSystemShapesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbSystemShapesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbSystemShapesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbSystemShapeSummary> dbSystemShapes() {
        Function<ListDbSystemShapesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSystemShapes() != null) {
                return response.dbSystemShapes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbSystemShapesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbSystemShapesResponseFetcher
    implements AsyncPageFetcher<ListDbSystemShapesResponse> {
        private ListDbSystemShapesResponseFetcher() {
        }

        public boolean hasNextPage(ListDbSystemShapesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbSystemShapesResponse> nextPage(ListDbSystemShapesResponse previousPage) {
            if (previousPage == null) {
                return ListDbSystemShapesPublisher.this.client.listDbSystemShapes(ListDbSystemShapesPublisher.this.firstRequest);
            }
            return ListDbSystemShapesPublisher.this.client.listDbSystemShapes((ListDbSystemShapesRequest)((Object)ListDbSystemShapesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

