/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.GiVersionSummary;
import software.amazon.awssdk.services.odb.model.ListGiVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListGiVersionsResponse;

public class ListGiVersionsIterable
implements SdkIterable<ListGiVersionsResponse> {
    private final OdbClient client;
    private final ListGiVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGiVersionsIterable(OdbClient client, ListGiVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGiVersionsResponseFetcher();
    }

    public Iterator<ListGiVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GiVersionSummary> giVersions() {
        Function<ListGiVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.giVersions() != null) {
                return response.giVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGiVersionsResponseFetcher
    implements SyncPageFetcher<ListGiVersionsResponse> {
        private ListGiVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListGiVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGiVersionsResponse nextPage(ListGiVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListGiVersionsIterable.this.client.listGiVersions(ListGiVersionsIterable.this.firstRequest);
            }
            return ListGiVersionsIterable.this.client.listGiVersions((ListGiVersionsRequest)((Object)ListGiVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

