/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralchannel.model.ChannelHandshakePayload;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeType;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.Tag;
import software.amazon.awssdk.services.partnercentralchannel.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelHandshakeRequest
extends PartnerCentralChannelRequest
implements ToCopyableBuilder<Builder, CreateChannelHandshakeRequest> {
    private static final SdkField<String> HANDSHAKE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("handshakeType").getter(CreateChannelHandshakeRequest.getter(CreateChannelHandshakeRequest::handshakeTypeAsString)).setter(CreateChannelHandshakeRequest.setter(Builder::handshakeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeType").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(CreateChannelHandshakeRequest.getter(CreateChannelHandshakeRequest::catalog)).setter(CreateChannelHandshakeRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedResourceIdentifier").getter(CreateChannelHandshakeRequest.getter(CreateChannelHandshakeRequest::associatedResourceIdentifier)).setter(CreateChannelHandshakeRequest.setter(Builder::associatedResourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResourceIdentifier").build()}).build();
    private static final SdkField<ChannelHandshakePayload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("payload").getter(CreateChannelHandshakeRequest.getter(CreateChannelHandshakeRequest::payload)).setter(CreateChannelHandshakeRequest.setter(Builder::payload)).constructor(ChannelHandshakePayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateChannelHandshakeRequest.getter(CreateChannelHandshakeRequest::clientToken)).setter(CreateChannelHandshakeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateChannelHandshakeRequest.getter(CreateChannelHandshakeRequest::tags)).setter(CreateChannelHandshakeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKE_TYPE_FIELD, CATALOG_FIELD, ASSOCIATED_RESOURCE_IDENTIFIER_FIELD, PAYLOAD_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateChannelHandshakeRequest.memberNameToFieldInitializer();
    private final String handshakeType;
    private final String catalog;
    private final String associatedResourceIdentifier;
    private final ChannelHandshakePayload payload;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateChannelHandshakeRequest(BuilderImpl builder) {
        super(builder);
        this.handshakeType = builder.handshakeType;
        this.catalog = builder.catalog;
        this.associatedResourceIdentifier = builder.associatedResourceIdentifier;
        this.payload = builder.payload;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final HandshakeType handshakeType() {
        return HandshakeType.fromValue(this.handshakeType);
    }

    public final String handshakeTypeAsString() {
        return this.handshakeType;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String associatedResourceIdentifier() {
        return this.associatedResourceIdentifier;
    }

    public final ChannelHandshakePayload payload() {
        return this.payload;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.handshakeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelHandshakeRequest)) {
            return false;
        }
        CreateChannelHandshakeRequest other = (CreateChannelHandshakeRequest)((Object)obj);
        return Objects.equals(this.handshakeTypeAsString(), other.handshakeTypeAsString()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.associatedResourceIdentifier(), other.associatedResourceIdentifier()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelHandshakeRequest").add("HandshakeType", (Object)this.handshakeTypeAsString()).add("Catalog", (Object)this.catalog()).add("AssociatedResourceIdentifier", (Object)this.associatedResourceIdentifier()).add("Payload", (Object)this.payload()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "handshakeType": {
                return Optional.ofNullable(clazz.cast(this.handshakeTypeAsString()));
            }
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "associatedResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceIdentifier()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handshakeType", HANDSHAKE_TYPE_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("associatedResourceIdentifier", ASSOCIATED_RESOURCE_IDENTIFIER_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelHandshakeRequest, T> g) {
        return obj -> g.apply((CreateChannelHandshakeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralChannelRequest.BuilderImpl
    implements Builder {
        private String handshakeType;
        private String catalog;
        private String associatedResourceIdentifier;
        private ChannelHandshakePayload payload;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelHandshakeRequest model) {
            super(model);
            this.handshakeType(model.handshakeType);
            this.catalog(model.catalog);
            this.associatedResourceIdentifier(model.associatedResourceIdentifier);
            this.payload(model.payload);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getHandshakeType() {
            return this.handshakeType;
        }

        public final void setHandshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
        }

        @Override
        public final Builder handshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
            return this;
        }

        @Override
        public final Builder handshakeType(HandshakeType handshakeType) {
            this.handshakeType(handshakeType == null ? null : handshakeType.toString());
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getAssociatedResourceIdentifier() {
            return this.associatedResourceIdentifier;
        }

        public final void setAssociatedResourceIdentifier(String associatedResourceIdentifier) {
            this.associatedResourceIdentifier = associatedResourceIdentifier;
        }

        @Override
        public final Builder associatedResourceIdentifier(String associatedResourceIdentifier) {
            this.associatedResourceIdentifier = associatedResourceIdentifier;
            return this;
        }

        public final ChannelHandshakePayload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(ChannelHandshakePayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(ChannelHandshakePayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelHandshakeRequest build() {
            return new CreateChannelHandshakeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralChannelRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelHandshakeRequest> {
        public Builder handshakeType(String var1);

        public Builder handshakeType(HandshakeType var1);

        public Builder catalog(String var1);

        public Builder associatedResourceIdentifier(String var1);

        public Builder payload(ChannelHandshakePayload var1);

        default public Builder payload(Consumer<ChannelHandshakePayload.Builder> payload) {
            return this.payload((ChannelHandshakePayload)((ChannelHandshakePayload.Builder)ChannelHandshakePayload.builder().applyMutation(payload)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

