/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralchannel.model.AssociationType;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ResaleAccountModel;
import software.amazon.awssdk.services.partnercentralchannel.model.Sector;
import software.amazon.awssdk.services.partnercentralchannel.model.SupportPlan;
import software.amazon.awssdk.services.partnercentralchannel.model.Tag;
import software.amazon.awssdk.services.partnercentralchannel.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRelationshipRequest
extends PartnerCentralChannelRequest
implements ToCopyableBuilder<Builder, CreateRelationshipRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::catalog)).setter(CreateRelationshipRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationType").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::associationTypeAsString)).setter(CreateRelationshipRequest.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final SdkField<String> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("programManagementAccountIdentifier").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::programManagementAccountIdentifier)).setter(CreateRelationshipRequest.setter(Builder::programManagementAccountIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountIdentifier").build()}).build();
    private static final SdkField<String> ASSOCIATED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedAccountId").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::associatedAccountId)).setter(CreateRelationshipRequest.setter(Builder::associatedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccountId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::displayName)).setter(CreateRelationshipRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> RESALE_ACCOUNT_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resaleAccountModel").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::resaleAccountModelAsString)).setter(CreateRelationshipRequest.setter(Builder::resaleAccountModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resaleAccountModel").build()}).build();
    private static final SdkField<String> SECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sector").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::sectorAsString)).setter(CreateRelationshipRequest.setter(Builder::sector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::clientToken)).setter(CreateRelationshipRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::tags)).setter(CreateRelationshipRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SupportPlan> REQUESTED_SUPPORT_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestedSupportPlan").getter(CreateRelationshipRequest.getter(CreateRelationshipRequest::requestedSupportPlan)).setter(CreateRelationshipRequest.setter(Builder::requestedSupportPlan)).constructor(SupportPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedSupportPlan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ASSOCIATION_TYPE_FIELD, PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD, ASSOCIATED_ACCOUNT_ID_FIELD, DISPLAY_NAME_FIELD, RESALE_ACCOUNT_MODEL_FIELD, SECTOR_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, REQUESTED_SUPPORT_PLAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRelationshipRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String associationType;
    private final String programManagementAccountIdentifier;
    private final String associatedAccountId;
    private final String displayName;
    private final String resaleAccountModel;
    private final String sector;
    private final String clientToken;
    private final List<Tag> tags;
    private final SupportPlan requestedSupportPlan;

    private CreateRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.associationType = builder.associationType;
        this.programManagementAccountIdentifier = builder.programManagementAccountIdentifier;
        this.associatedAccountId = builder.associatedAccountId;
        this.displayName = builder.displayName;
        this.resaleAccountModel = builder.resaleAccountModel;
        this.sector = builder.sector;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.requestedSupportPlan = builder.requestedSupportPlan;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final AssociationType associationType() {
        return AssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public final String programManagementAccountIdentifier() {
        return this.programManagementAccountIdentifier;
    }

    public final String associatedAccountId() {
        return this.associatedAccountId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResaleAccountModel resaleAccountModel() {
        return ResaleAccountModel.fromValue(this.resaleAccountModel);
    }

    public final String resaleAccountModelAsString() {
        return this.resaleAccountModel;
    }

    public final Sector sector() {
        return Sector.fromValue(this.sector);
    }

    public final String sectorAsString() {
        return this.sector;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SupportPlan requestedSupportPlan() {
        return this.requestedSupportPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programManagementAccountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resaleAccountModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedSupportPlan());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationshipRequest)) {
            return false;
        }
        CreateRelationshipRequest other = (CreateRelationshipRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && Objects.equals(this.programManagementAccountIdentifier(), other.programManagementAccountIdentifier()) && Objects.equals(this.associatedAccountId(), other.associatedAccountId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.resaleAccountModelAsString(), other.resaleAccountModelAsString()) && Objects.equals(this.sectorAsString(), other.sectorAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.requestedSupportPlan(), other.requestedSupportPlan());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRelationshipRequest").add("Catalog", (Object)this.catalog()).add("AssociationType", (Object)this.associationTypeAsString()).add("ProgramManagementAccountIdentifier", (Object)this.programManagementAccountIdentifier()).add("AssociatedAccountId", (Object)this.associatedAccountId()).add("DisplayName", (Object)this.displayName()).add("ResaleAccountModel", (Object)this.resaleAccountModelAsString()).add("Sector", (Object)this.sectorAsString()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("RequestedSupportPlan", (Object)this.requestedSupportPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "programManagementAccountIdentifier": {
                return Optional.ofNullable(clazz.cast(this.programManagementAccountIdentifier()));
            }
            case "associatedAccountId": {
                return Optional.ofNullable(clazz.cast(this.associatedAccountId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "resaleAccountModel": {
                return Optional.ofNullable(clazz.cast(this.resaleAccountModelAsString()));
            }
            case "sector": {
                return Optional.ofNullable(clazz.cast(this.sectorAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "requestedSupportPlan": {
                return Optional.ofNullable(clazz.cast(this.requestedSupportPlan()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalog", CATALOG_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        map.put("programManagementAccountIdentifier", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD);
        map.put("associatedAccountId", ASSOCIATED_ACCOUNT_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("resaleAccountModel", RESALE_ACCOUNT_MODEL_FIELD);
        map.put("sector", SECTOR_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("requestedSupportPlan", REQUESTED_SUPPORT_PLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationshipRequest, T> g) {
        return obj -> g.apply((CreateRelationshipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralChannelRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String associationType;
        private String programManagementAccountIdentifier;
        private String associatedAccountId;
        private String displayName;
        private String resaleAccountModel;
        private String sector;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private SupportPlan requestedSupportPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationshipRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.associationType(model.associationType);
            this.programManagementAccountIdentifier(model.programManagementAccountIdentifier);
            this.associatedAccountId(model.associatedAccountId);
            this.displayName(model.displayName);
            this.resaleAccountModel(model.resaleAccountModel);
            this.sector(model.sector);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.requestedSupportPlan(model.requestedSupportPlan);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getProgramManagementAccountIdentifier() {
            return this.programManagementAccountIdentifier;
        }

        public final void setProgramManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
        }

        @Override
        public final Builder programManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
            return this;
        }

        public final String getAssociatedAccountId() {
            return this.associatedAccountId;
        }

        public final void setAssociatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
        }

        @Override
        public final Builder associatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getResaleAccountModel() {
            return this.resaleAccountModel;
        }

        public final void setResaleAccountModel(String resaleAccountModel) {
            this.resaleAccountModel = resaleAccountModel;
        }

        @Override
        public final Builder resaleAccountModel(String resaleAccountModel) {
            this.resaleAccountModel = resaleAccountModel;
            return this;
        }

        @Override
        public final Builder resaleAccountModel(ResaleAccountModel resaleAccountModel) {
            this.resaleAccountModel(resaleAccountModel == null ? null : resaleAccountModel.toString());
            return this;
        }

        public final String getSector() {
            return this.sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SupportPlan.Builder getRequestedSupportPlan() {
            return this.requestedSupportPlan != null ? this.requestedSupportPlan.toBuilder() : null;
        }

        public final void setRequestedSupportPlan(SupportPlan.BuilderImpl requestedSupportPlan) {
            this.requestedSupportPlan = requestedSupportPlan != null ? requestedSupportPlan.build() : null;
        }

        @Override
        public final Builder requestedSupportPlan(SupportPlan requestedSupportPlan) {
            this.requestedSupportPlan = requestedSupportPlan;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationshipRequest build() {
            return new CreateRelationshipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralChannelRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRelationshipRequest> {
        public Builder catalog(String var1);

        public Builder associationType(String var1);

        public Builder associationType(AssociationType var1);

        public Builder programManagementAccountIdentifier(String var1);

        public Builder associatedAccountId(String var1);

        public Builder displayName(String var1);

        public Builder resaleAccountModel(String var1);

        public Builder resaleAccountModel(ResaleAccountModel var1);

        public Builder sector(String var1);

        public Builder sector(Sector var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder requestedSupportPlan(SupportPlan var1);

        default public Builder requestedSupportPlan(Consumer<SupportPlan.Builder> requestedSupportPlan) {
            return this.requestedSupportPlan((SupportPlan)((SupportPlan.Builder)SupportPlan.builder().applyMutation(requestedSupportPlan)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

