/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralchannel.model.AccountIdListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsSortBase;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.Program;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountDisplayNameListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountStatus;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProgramManagementAccountsRequest
extends PartnerCentralChannelRequest
implements ToCopyableBuilder<Builder, ListProgramManagementAccountsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::catalog)).setter(ListProgramManagementAccountsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::maxResults)).setter(ListProgramManagementAccountsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> DISPLAY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("displayNames").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::displayNames)).setter(ListProgramManagementAccountsRequest.setter(Builder::displayNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("programs").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::programsAsStrings)).setter(ListProgramManagementAccountsRequest.setter(Builder::programsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::accountIds)).setter(ListProgramManagementAccountsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::statusesAsStrings)).setter(ListProgramManagementAccountsRequest.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ListProgramManagementAccountsSortBase> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sort").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::sort)).setter(ListProgramManagementAccountsRequest.setter(Builder::sort)).constructor(ListProgramManagementAccountsSortBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProgramManagementAccountsRequest.getter(ListProgramManagementAccountsRequest::nextToken)).setter(ListProgramManagementAccountsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, MAX_RESULTS_FIELD, DISPLAY_NAMES_FIELD, PROGRAMS_FIELD, ACCOUNT_IDS_FIELD, STATUSES_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProgramManagementAccountsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final Integer maxResults;
    private final List<String> displayNames;
    private final List<String> programs;
    private final List<String> accountIds;
    private final List<String> statuses;
    private final ListProgramManagementAccountsSortBase sort;
    private final String nextToken;

    private ListProgramManagementAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.maxResults = builder.maxResults;
        this.displayNames = builder.displayNames;
        this.programs = builder.programs;
        this.accountIds = builder.accountIds;
        this.statuses = builder.statuses;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasDisplayNames() {
        return this.displayNames != null && !(this.displayNames instanceof SdkAutoConstructList);
    }

    public final List<String> displayNames() {
        return this.displayNames;
    }

    public final List<Program> programs() {
        return ProgramListCopier.copyStringToEnum(this.programs);
    }

    public final boolean hasPrograms() {
        return this.programs != null && !(this.programs instanceof SdkAutoConstructList);
    }

    public final List<String> programsAsStrings() {
        return this.programs;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final List<ProgramManagementAccountStatus> statuses() {
        return ProgramManagementAccountStatusListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final ListProgramManagementAccountsSortBase sort() {
        return this.sort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisplayNames() ? this.displayNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrograms() ? this.programsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProgramManagementAccountsRequest)) {
            return false;
        }
        ListProgramManagementAccountsRequest other = (ListProgramManagementAccountsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasDisplayNames() == other.hasDisplayNames() && Objects.equals(this.displayNames(), other.displayNames()) && this.hasPrograms() == other.hasPrograms() && Objects.equals(this.programsAsStrings(), other.programsAsStrings()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProgramManagementAccountsRequest").add("Catalog", (Object)this.catalog()).add("MaxResults", (Object)this.maxResults()).add("DisplayNames", this.hasDisplayNames() ? this.displayNames() : null).add("Programs", this.hasPrograms() ? this.programsAsStrings() : null).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("Sort", (Object)this.sort()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "displayNames": {
                return Optional.ofNullable(clazz.cast(this.displayNames()));
            }
            case "programs": {
                return Optional.ofNullable(clazz.cast(this.programsAsStrings()));
            }
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalog", CATALOG_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("displayNames", DISPLAY_NAMES_FIELD);
        map.put("programs", PROGRAMS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProgramManagementAccountsRequest, T> g) {
        return obj -> g.apply((ListProgramManagementAccountsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralChannelRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private Integer maxResults;
        private List<String> displayNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> programs = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private ListProgramManagementAccountsSortBase sort;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProgramManagementAccountsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.maxResults(model.maxResults);
            this.displayNames(model.displayNames);
            this.programsWithStrings(model.programs);
            this.accountIds(model.accountIds);
            this.statusesWithStrings(model.statuses);
            this.sort(model.sort);
            this.nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getDisplayNames() {
            if (this.displayNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.displayNames;
        }

        public final void setDisplayNames(Collection<String> displayNames) {
            this.displayNames = ProgramManagementAccountDisplayNameListCopier.copy(displayNames);
        }

        @Override
        public final Builder displayNames(Collection<String> displayNames) {
            this.displayNames = ProgramManagementAccountDisplayNameListCopier.copy(displayNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder displayNames(String ... displayNames) {
            this.displayNames(Arrays.asList(displayNames));
            return this;
        }

        public final Collection<String> getPrograms() {
            if (this.programs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
        }

        @Override
        public final Builder programsWithStrings(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programsWithStrings(String ... programs) {
            this.programsWithStrings(Arrays.asList(programs));
            return this;
        }

        @Override
        public final Builder programs(Collection<Program> programs) {
            this.programs = ProgramListCopier.copyEnumToString(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(Program ... programs) {
            this.programs(Arrays.asList(programs));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ProgramManagementAccountStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ProgramManagementAccountStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ProgramManagementAccountStatus> statuses) {
            this.statuses = ProgramManagementAccountStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ProgramManagementAccountStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final ListProgramManagementAccountsSortBase.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(ListProgramManagementAccountsSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListProgramManagementAccountsSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProgramManagementAccountsRequest build() {
            return new ListProgramManagementAccountsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralChannelRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProgramManagementAccountsRequest> {
        public Builder catalog(String var1);

        public Builder maxResults(Integer var1);

        public Builder displayNames(Collection<String> var1);

        public Builder displayNames(String ... var1);

        public Builder programsWithStrings(Collection<String> var1);

        public Builder programsWithStrings(String ... var1);

        public Builder programs(Collection<Program> var1);

        public Builder programs(Program ... var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<ProgramManagementAccountStatus> var1);

        public Builder statuses(ProgramManagementAccountStatus ... var1);

        public Builder sort(ListProgramManagementAccountsSortBase var1);

        default public Builder sort(Consumer<ListProgramManagementAccountsSortBase.Builder> sort) {
            return this.sort((ListProgramManagementAccountsSortBase)((ListProgramManagementAccountsSortBase.Builder)ListProgramManagementAccountsSortBase.builder().applyMutation(sort)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

