/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralchannel.model.AccountIdListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.AssociationType;
import software.amazon.awssdk.services.partnercentralchannel.model.AssociationTypeListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsSortBase;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.RelationshipDisplayNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRelationshipsRequest
extends PartnerCentralChannelRequest
implements ToCopyableBuilder<Builder, ListRelationshipsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::catalog)).setter(ListRelationshipsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::maxResults)).setter(ListRelationshipsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedAccountIds").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::associatedAccountIds)).setter(ListRelationshipsRequest.setter(Builder::associatedAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associationTypes").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::associationTypesAsStrings)).setter(ListRelationshipsRequest.setter(Builder::associationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISPLAY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("displayNames").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::displayNames)).setter(ListRelationshipsRequest.setter(Builder::displayNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("programManagementAccountIdentifiers").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::programManagementAccountIdentifiers)).setter(ListRelationshipsRequest.setter(Builder::programManagementAccountIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ListRelationshipsSortBase> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sort").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::sort)).setter(ListRelationshipsRequest.setter(Builder::sort)).constructor(ListRelationshipsSortBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRelationshipsRequest.getter(ListRelationshipsRequest::nextToken)).setter(ListRelationshipsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, MAX_RESULTS_FIELD, ASSOCIATED_ACCOUNT_IDS_FIELD, ASSOCIATION_TYPES_FIELD, DISPLAY_NAMES_FIELD, PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIERS_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRelationshipsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final Integer maxResults;
    private final List<String> associatedAccountIds;
    private final List<String> associationTypes;
    private final List<String> displayNames;
    private final List<String> programManagementAccountIdentifiers;
    private final ListRelationshipsSortBase sort;
    private final String nextToken;

    private ListRelationshipsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.maxResults = builder.maxResults;
        this.associatedAccountIds = builder.associatedAccountIds;
        this.associationTypes = builder.associationTypes;
        this.displayNames = builder.displayNames;
        this.programManagementAccountIdentifiers = builder.programManagementAccountIdentifiers;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasAssociatedAccountIds() {
        return this.associatedAccountIds != null && !(this.associatedAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> associatedAccountIds() {
        return this.associatedAccountIds;
    }

    public final List<AssociationType> associationTypes() {
        return AssociationTypeListCopier.copyStringToEnum(this.associationTypes);
    }

    public final boolean hasAssociationTypes() {
        return this.associationTypes != null && !(this.associationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> associationTypesAsStrings() {
        return this.associationTypes;
    }

    public final boolean hasDisplayNames() {
        return this.displayNames != null && !(this.displayNames instanceof SdkAutoConstructList);
    }

    public final List<String> displayNames() {
        return this.displayNames;
    }

    public final boolean hasProgramManagementAccountIdentifiers() {
        return this.programManagementAccountIdentifiers != null && !(this.programManagementAccountIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> programManagementAccountIdentifiers() {
        return this.programManagementAccountIdentifiers;
    }

    public final ListRelationshipsSortBase sort() {
        return this.sort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedAccountIds() ? this.associatedAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationTypes() ? this.associationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisplayNames() ? this.displayNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProgramManagementAccountIdentifiers() ? this.programManagementAccountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelationshipsRequest)) {
            return false;
        }
        ListRelationshipsRequest other = (ListRelationshipsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasAssociatedAccountIds() == other.hasAssociatedAccountIds() && Objects.equals(this.associatedAccountIds(), other.associatedAccountIds()) && this.hasAssociationTypes() == other.hasAssociationTypes() && Objects.equals(this.associationTypesAsStrings(), other.associationTypesAsStrings()) && this.hasDisplayNames() == other.hasDisplayNames() && Objects.equals(this.displayNames(), other.displayNames()) && this.hasProgramManagementAccountIdentifiers() == other.hasProgramManagementAccountIdentifiers() && Objects.equals(this.programManagementAccountIdentifiers(), other.programManagementAccountIdentifiers()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRelationshipsRequest").add("Catalog", (Object)this.catalog()).add("MaxResults", (Object)this.maxResults()).add("AssociatedAccountIds", this.hasAssociatedAccountIds() ? this.associatedAccountIds() : null).add("AssociationTypes", this.hasAssociationTypes() ? this.associationTypesAsStrings() : null).add("DisplayNames", this.hasDisplayNames() ? this.displayNames() : null).add("ProgramManagementAccountIdentifiers", this.hasProgramManagementAccountIdentifiers() ? this.programManagementAccountIdentifiers() : null).add("Sort", (Object)this.sort()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "associatedAccountIds": {
                return Optional.ofNullable(clazz.cast(this.associatedAccountIds()));
            }
            case "associationTypes": {
                return Optional.ofNullable(clazz.cast(this.associationTypesAsStrings()));
            }
            case "displayNames": {
                return Optional.ofNullable(clazz.cast(this.displayNames()));
            }
            case "programManagementAccountIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.programManagementAccountIdentifiers()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalog", CATALOG_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("associatedAccountIds", ASSOCIATED_ACCOUNT_IDS_FIELD);
        map.put("associationTypes", ASSOCIATION_TYPES_FIELD);
        map.put("displayNames", DISPLAY_NAMES_FIELD);
        map.put("programManagementAccountIdentifiers", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIERS_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRelationshipsRequest, T> g) {
        return obj -> g.apply((ListRelationshipsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralChannelRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private Integer maxResults;
        private List<String> associatedAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> associationTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> displayNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> programManagementAccountIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private ListRelationshipsSortBase sort;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRelationshipsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.maxResults(model.maxResults);
            this.associatedAccountIds(model.associatedAccountIds);
            this.associationTypesWithStrings(model.associationTypes);
            this.displayNames(model.displayNames);
            this.programManagementAccountIdentifiers(model.programManagementAccountIdentifiers);
            this.sort(model.sort);
            this.nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getAssociatedAccountIds() {
            if (this.associatedAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedAccountIds;
        }

        public final void setAssociatedAccountIds(Collection<String> associatedAccountIds) {
            this.associatedAccountIds = AccountIdListCopier.copy(associatedAccountIds);
        }

        @Override
        public final Builder associatedAccountIds(Collection<String> associatedAccountIds) {
            this.associatedAccountIds = AccountIdListCopier.copy(associatedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedAccountIds(String ... associatedAccountIds) {
            this.associatedAccountIds(Arrays.asList(associatedAccountIds));
            return this;
        }

        public final Collection<String> getAssociationTypes() {
            if (this.associationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associationTypes;
        }

        public final void setAssociationTypes(Collection<String> associationTypes) {
            this.associationTypes = AssociationTypeListCopier.copy(associationTypes);
        }

        @Override
        public final Builder associationTypesWithStrings(Collection<String> associationTypes) {
            this.associationTypes = AssociationTypeListCopier.copy(associationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationTypesWithStrings(String ... associationTypes) {
            this.associationTypesWithStrings(Arrays.asList(associationTypes));
            return this;
        }

        @Override
        public final Builder associationTypes(Collection<AssociationType> associationTypes) {
            this.associationTypes = AssociationTypeListCopier.copyEnumToString(associationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationTypes(AssociationType ... associationTypes) {
            this.associationTypes(Arrays.asList(associationTypes));
            return this;
        }

        public final Collection<String> getDisplayNames() {
            if (this.displayNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.displayNames;
        }

        public final void setDisplayNames(Collection<String> displayNames) {
            this.displayNames = RelationshipDisplayNameListCopier.copy(displayNames);
        }

        @Override
        public final Builder displayNames(Collection<String> displayNames) {
            this.displayNames = RelationshipDisplayNameListCopier.copy(displayNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder displayNames(String ... displayNames) {
            this.displayNames(Arrays.asList(displayNames));
            return this;
        }

        public final Collection<String> getProgramManagementAccountIdentifiers() {
            if (this.programManagementAccountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.programManagementAccountIdentifiers;
        }

        public final void setProgramManagementAccountIdentifiers(Collection<String> programManagementAccountIdentifiers) {
            this.programManagementAccountIdentifiers = ProgramManagementAccountIdentifierListCopier.copy(programManagementAccountIdentifiers);
        }

        @Override
        public final Builder programManagementAccountIdentifiers(Collection<String> programManagementAccountIdentifiers) {
            this.programManagementAccountIdentifiers = ProgramManagementAccountIdentifierListCopier.copy(programManagementAccountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programManagementAccountIdentifiers(String ... programManagementAccountIdentifiers) {
            this.programManagementAccountIdentifiers(Arrays.asList(programManagementAccountIdentifiers));
            return this;
        }

        public final ListRelationshipsSortBase.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(ListRelationshipsSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListRelationshipsSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRelationshipsRequest build() {
            return new ListRelationshipsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralChannelRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRelationshipsRequest> {
        public Builder catalog(String var1);

        public Builder maxResults(Integer var1);

        public Builder associatedAccountIds(Collection<String> var1);

        public Builder associatedAccountIds(String ... var1);

        public Builder associationTypesWithStrings(Collection<String> var1);

        public Builder associationTypesWithStrings(String ... var1);

        public Builder associationTypes(Collection<AssociationType> var1);

        public Builder associationTypes(AssociationType ... var1);

        public Builder displayNames(Collection<String> var1);

        public Builder displayNames(String ... var1);

        public Builder programManagementAccountIdentifiers(Collection<String> var1);

        public Builder programManagementAccountIdentifiers(String ... var1);

        public Builder sort(ListRelationshipsSortBase var1);

        default public Builder sort(Consumer<ListRelationshipsSortBase.Builder> sort) {
            return this.sort((ListRelationshipsSortBase)((ListRelationshipsSortBase.Builder)ListRelationshipsSortBase.builder().applyMutation(sort)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

