/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.DimensionValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionMapping> {
    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionValue").getter(DimensionMapping.getter(DimensionMapping::dimensionValue)).setter(DimensionMapping.setter(Builder::dimensionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()}).build();
    private static final SdkField<String> DIMENSION_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionValueType").getter(DimensionMapping.getter(DimensionMapping::dimensionValueTypeAsString)).setter(DimensionMapping.setter(Builder::dimensionValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueType").build()}).build();
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionName").getter(DimensionMapping.getter(DimensionMapping::dimensionName)).setter(DimensionMapping.setter(Builder::dimensionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUE_FIELD, DIMENSION_VALUE_TYPE_FIELD, DIMENSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DimensionMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dimensionValue;
    private final String dimensionValueType;
    private final String dimensionName;

    private DimensionMapping(BuilderImpl builder) {
        this.dimensionValue = builder.dimensionValue;
        this.dimensionValueType = builder.dimensionValueType;
        this.dimensionName = builder.dimensionName;
    }

    public final String dimensionValue() {
        return this.dimensionValue;
    }

    public final DimensionValueType dimensionValueType() {
        return DimensionValueType.fromValue(this.dimensionValueType);
    }

    public final String dimensionValueTypeAsString() {
        return this.dimensionValueType;
    }

    public final String dimensionName() {
        return this.dimensionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionMapping)) {
            return false;
        }
        DimensionMapping other = (DimensionMapping)obj;
        return Objects.equals(this.dimensionValue(), other.dimensionValue()) && Objects.equals(this.dimensionValueTypeAsString(), other.dimensionValueTypeAsString()) && Objects.equals(this.dimensionName(), other.dimensionName());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionMapping").add("DimensionValue", (Object)this.dimensionValue()).add("DimensionValueType", (Object)this.dimensionValueTypeAsString()).add("DimensionName", (Object)this.dimensionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionValue": {
                return Optional.ofNullable(clazz.cast(this.dimensionValue()));
            }
            case "DimensionValueType": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueTypeAsString()));
            }
            case "DimensionName": {
                return Optional.ofNullable(clazz.cast(this.dimensionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DimensionValue", DIMENSION_VALUE_FIELD);
        map.put("DimensionValueType", DIMENSION_VALUE_TYPE_FIELD);
        map.put("DimensionName", DIMENSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionMapping, T> g) {
        return obj -> g.apply((DimensionMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionValue;
        private String dimensionValueType;
        private String dimensionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionMapping model) {
            this.dimensionValue(model.dimensionValue);
            this.dimensionValueType(model.dimensionValueType);
            this.dimensionName(model.dimensionName);
        }

        public final String getDimensionValue() {
            return this.dimensionValue;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        public final String getDimensionValueType() {
            return this.dimensionValueType;
        }

        public final void setDimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
        }

        @Override
        public final Builder dimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
            return this;
        }

        @Override
        public final Builder dimensionValueType(DimensionValueType dimensionValueType) {
            this.dimensionValueType(dimensionValueType == null ? null : dimensionValueType.toString());
            return this;
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public DimensionMapping build() {
            return new DimensionMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionMapping> {
        public Builder dimensionValue(String var1);

        public Builder dimensionValueType(String var1);

        public Builder dimensionValueType(DimensionValueType var1);

        public Builder dimensionName(String var1);
    }
}

