/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3OutputFormat {
    JSON("json"),
    PLAIN("plain"),
    W3_C("w3c"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3OutputFormat> VALUE_MAP;
    private final String value;

    private S3OutputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3OutputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3OutputFormat> knownValues() {
        EnumSet<S3OutputFormat> knownValues = EnumSet.allOf(S3OutputFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3OutputFormat.class, S3OutputFormat::toString);
    }
}

