/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClusterCredentialsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, GetClusterCredentialsResponse> {
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(GetClusterCredentialsResponse.getter(GetClusterCredentialsResponse::dbUser)).setter(GetClusterCredentialsResponse.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbPassword").getter(GetClusterCredentialsResponse.getter(GetClusterCredentialsResponse::dbPassword)).setter(GetClusterCredentialsResponse.setter(Builder::dbPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Expiration").getter(GetClusterCredentialsResponse.getter(GetClusterCredentialsResponse::expiration)).setter(GetClusterCredentialsResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_USER_FIELD, DB_PASSWORD_FIELD, EXPIRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetClusterCredentialsResponse.memberNameToFieldInitializer();
    private final String dbUser;
    private final String dbPassword;
    private final Instant expiration;

    private GetClusterCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.expiration = builder.expiration;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String dbPassword() {
        return this.dbPassword;
    }

    public final Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsResponse)) {
            return false;
        }
        GetClusterCredentialsResponse other = (GetClusterCredentialsResponse)((Object)obj);
        return Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword()) && Objects.equals(this.expiration(), other.expiration());
    }

    public final String toString() {
        return ToString.builder((String)"GetClusterCredentialsResponse").add("DbUser", (Object)this.dbUser()).add("DbPassword", (Object)(this.dbPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("Expiration", (Object)this.expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.ofNullable(clazz.cast(this.dbPassword()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DbUser", DB_USER_FIELD);
        map.put("DbPassword", DB_PASSWORD_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsResponse, T> g) {
        return obj -> g.apply((GetClusterCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String dbUser;
        private String dbPassword;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsResponse model) {
            super(model);
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
            this.expiration(model.expiration);
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public GetClusterCredentialsResponse build() {
            return new GetClusterCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClusterCredentialsResponse> {
        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder expiration(Instant var1);
    }
}

