/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasClient;
import software.amazon.awssdk.services.schemas.internal.UserAgentUtils;
import software.amazon.awssdk.services.schemas.model.ListRegistriesRequest;
import software.amazon.awssdk.services.schemas.model.ListRegistriesResponse;
import software.amazon.awssdk.services.schemas.model.RegistrySummary;

public class ListRegistriesIterable
implements SdkIterable<ListRegistriesResponse> {
    private final SchemasClient client;
    private final ListRegistriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRegistriesIterable(SchemasClient client, ListRegistriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRegistriesResponseFetcher();
    }

    public Iterator<ListRegistriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrySummary> registries() {
        Function<ListRegistriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registries() != null) {
                return response.registries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRegistriesResponseFetcher
    implements SyncPageFetcher<ListRegistriesResponse> {
        private ListRegistriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRegistriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRegistriesResponse nextPage(ListRegistriesResponse previousPage) {
            if (previousPage == null) {
                return ListRegistriesIterable.this.client.listRegistries(ListRegistriesIterable.this.firstRequest);
            }
            return ListRegistriesIterable.this.client.listRegistries((ListRegistriesRequest)((Object)ListRegistriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

