/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.WabaPhoneNumberSetupFinalization;
import software.amazon.awssdk.services.socialmessaging.model.WabaPhoneNumberSetupFinalizationListCopier;
import software.amazon.awssdk.services.socialmessaging.model.WabaSetupFinalization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WhatsAppSetupFinalization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WhatsAppSetupFinalization> {
    private static final SdkField<String> ASSOCIATE_IN_PROGRESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associateInProgressToken").getter(WhatsAppSetupFinalization.getter(WhatsAppSetupFinalization::associateInProgressToken)).setter(WhatsAppSetupFinalization.setter(Builder::associateInProgressToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateInProgressToken").build()}).build();
    private static final SdkField<List<WabaPhoneNumberSetupFinalization>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("phoneNumbers").getter(WhatsAppSetupFinalization.getter(WhatsAppSetupFinalization::phoneNumbers)).setter(WhatsAppSetupFinalization.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WabaPhoneNumberSetupFinalization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PHONE_NUMBER_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phoneNumberParent").getter(WhatsAppSetupFinalization.getter(WhatsAppSetupFinalization::phoneNumberParent)).setter(WhatsAppSetupFinalization.setter(Builder::phoneNumberParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumberParent").build()}).build();
    private static final SdkField<WabaSetupFinalization> WABA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("waba").getter(WhatsAppSetupFinalization.getter(WhatsAppSetupFinalization::waba)).setter(WhatsAppSetupFinalization.setter(Builder::waba)).constructor(WabaSetupFinalization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waba").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_IN_PROGRESS_TOKEN_FIELD, PHONE_NUMBERS_FIELD, PHONE_NUMBER_PARENT_FIELD, WABA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WhatsAppSetupFinalization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associateInProgressToken;
    private final List<WabaPhoneNumberSetupFinalization> phoneNumbers;
    private final String phoneNumberParent;
    private final WabaSetupFinalization waba;

    private WhatsAppSetupFinalization(BuilderImpl builder) {
        this.associateInProgressToken = builder.associateInProgressToken;
        this.phoneNumbers = builder.phoneNumbers;
        this.phoneNumberParent = builder.phoneNumberParent;
        this.waba = builder.waba;
    }

    public final String associateInProgressToken() {
        return this.associateInProgressToken;
    }

    public final boolean hasPhoneNumbers() {
        return this.phoneNumbers != null && !(this.phoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<WabaPhoneNumberSetupFinalization> phoneNumbers() {
        return this.phoneNumbers;
    }

    public final String phoneNumberParent() {
        return this.phoneNumberParent;
    }

    public final WabaSetupFinalization waba() {
        return this.waba;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associateInProgressToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumbers() ? this.phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.waba());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppSetupFinalization)) {
            return false;
        }
        WhatsAppSetupFinalization other = (WhatsAppSetupFinalization)obj;
        return Objects.equals(this.associateInProgressToken(), other.associateInProgressToken()) && this.hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && Objects.equals(this.phoneNumberParent(), other.phoneNumberParent()) && Objects.equals(this.waba(), other.waba());
    }

    public final String toString() {
        return ToString.builder((String)"WhatsAppSetupFinalization").add("AssociateInProgressToken", (Object)(this.associateInProgressToken() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumbers", this.hasPhoneNumbers() ? this.phoneNumbers() : null).add("PhoneNumberParent", (Object)this.phoneNumberParent()).add("Waba", (Object)this.waba()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associateInProgressToken": {
                return Optional.ofNullable(clazz.cast(this.associateInProgressToken()));
            }
            case "phoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "phoneNumberParent": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberParent()));
            }
            case "waba": {
                return Optional.ofNullable(clazz.cast(this.waba()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associateInProgressToken", ASSOCIATE_IN_PROGRESS_TOKEN_FIELD);
        map.put("phoneNumbers", PHONE_NUMBERS_FIELD);
        map.put("phoneNumberParent", PHONE_NUMBER_PARENT_FIELD);
        map.put("waba", WABA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppSetupFinalization, T> g) {
        return obj -> g.apply((WhatsAppSetupFinalization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associateInProgressToken;
        private List<WabaPhoneNumberSetupFinalization> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private String phoneNumberParent;
        private WabaSetupFinalization waba;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppSetupFinalization model) {
            this.associateInProgressToken(model.associateInProgressToken);
            this.phoneNumbers(model.phoneNumbers);
            this.phoneNumberParent(model.phoneNumberParent);
            this.waba(model.waba);
        }

        public final String getAssociateInProgressToken() {
            return this.associateInProgressToken;
        }

        public final void setAssociateInProgressToken(String associateInProgressToken) {
            this.associateInProgressToken = associateInProgressToken;
        }

        @Override
        public final Builder associateInProgressToken(String associateInProgressToken) {
            this.associateInProgressToken = associateInProgressToken;
            return this;
        }

        public final List<WabaPhoneNumberSetupFinalization.Builder> getPhoneNumbers() {
            List<WabaPhoneNumberSetupFinalization.Builder> result = WabaPhoneNumberSetupFinalizationListCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<WabaPhoneNumberSetupFinalization.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = WabaPhoneNumberSetupFinalizationListCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<WabaPhoneNumberSetupFinalization> phoneNumbers) {
            this.phoneNumbers = WabaPhoneNumberSetupFinalizationListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(WabaPhoneNumberSetupFinalization ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<WabaPhoneNumberSetupFinalization.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (WabaPhoneNumberSetupFinalization)((WabaPhoneNumberSetupFinalization.Builder)WabaPhoneNumberSetupFinalization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPhoneNumberParent() {
            return this.phoneNumberParent;
        }

        public final void setPhoneNumberParent(String phoneNumberParent) {
            this.phoneNumberParent = phoneNumberParent;
        }

        @Override
        public final Builder phoneNumberParent(String phoneNumberParent) {
            this.phoneNumberParent = phoneNumberParent;
            return this;
        }

        public final WabaSetupFinalization.Builder getWaba() {
            return this.waba != null ? this.waba.toBuilder() : null;
        }

        public final void setWaba(WabaSetupFinalization.BuilderImpl waba) {
            this.waba = waba != null ? waba.build() : null;
        }

        @Override
        public final Builder waba(WabaSetupFinalization waba) {
            this.waba = waba;
            return this;
        }

        public WhatsAppSetupFinalization build() {
            return new WhatsAppSetupFinalization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WhatsAppSetupFinalization> {
        public Builder associateInProgressToken(String var1);

        public Builder phoneNumbers(Collection<WabaPhoneNumberSetupFinalization> var1);

        public Builder phoneNumbers(WabaPhoneNumberSetupFinalization ... var1);

        public Builder phoneNumbers(Consumer<WabaPhoneNumberSetupFinalization.Builder> ... var1);

        public Builder phoneNumberParent(String var1);

        public Builder waba(WabaSetupFinalization var1);

        default public Builder waba(Consumer<WabaSetupFinalization.Builder> waba) {
            return this.waba((WabaSetupFinalization)((WabaSetupFinalization.Builder)WabaSetupFinalization.builder().applyMutation(waba)).build());
        }
    }
}

