/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;

public class JasperReportsMultiFormatView
extends AbstractJasperReportsView {
    public static final String DEFAULT_FORMAT_KEY = "format";
    private String formatKey = "format";
    private Map formatMappings = new HashMap(4);
    private Properties contentDispositionMappings;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView;

    public JasperReportsMultiFormatView() {
        this.formatMappings.put("csv", class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsCsvView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView);
        this.formatMappings.put("html", class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsHtmlView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView);
        this.formatMappings.put("pdf", class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsPdfView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView);
        this.formatMappings.put("xls", class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsXlsView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView);
    }

    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    public void setFormatMappings(Properties mappingsWithClassNames) {
        if (mappingsWithClassNames == null || mappingsWithClassNames.isEmpty()) {
            throw new IllegalArgumentException("formatMappings must not be empty");
        }
        this.formatMappings = new HashMap(mappingsWithClassNames.size());
        Enumeration<?> discriminators = mappingsWithClassNames.propertyNames();
        while (discriminators.hasMoreElements()) {
            String discriminator = (String)discriminators.nextElement();
            String className = mappingsWithClassNames.getProperty(discriminator);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapped view class [" + className + "] to mapping key [" + discriminator + "]"));
                }
                this.formatMappings.put(discriminator, ClassUtils.forName((String)className));
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Class [" + className + "] mapped to format [" + discriminator + "] cannot be found", (Throwable)ex);
            }
        }
    }

    public void setContentDispositionMappings(Properties mappings) {
        this.contentDispositionMappings = mappings;
    }

    public Properties getContentDispositionMappings() {
        return this.contentDispositionMappings;
    }

    protected void renderReport(JasperPrint populatedReport, Map model, HttpServletResponse response) throws Exception {
        Class viewClass;
        String format = (String)model.get(this.formatKey);
        if (format == null) {
            throw new IllegalArgumentException("No format format found in model");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering report using format mapping key [" + format + "]"));
        }
        if ((viewClass = (Class)this.formatMappings.get(format)) == null) {
            throw new IllegalArgumentException("Format discriminator [" + format + "] is not a configured mapping");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering report using view class [" + viewClass.getName() + "]"));
        }
        AbstractJasperReportsView view = (AbstractJasperReportsView)BeanUtils.instantiateClass((Class)viewClass);
        view.setExporterParameters(this.getExporterParameters());
        view.convertExporterParameters();
        response.setContentType(view.getContentType());
        this.populateContentDispositionIfNecessary(format, response);
        view.renderReport(populatedReport, model, response);
    }

    private void populateContentDispositionIfNecessary(String format, HttpServletResponse response) {
        String header;
        if (this.contentDispositionMappings != null && (header = this.contentDispositionMappings.getProperty(format)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting Content-Disposition header to: [" + header + "]"));
            }
            response.setHeader("Content-Disposition", header);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

