/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.buffer;

import com.suning.api.link.io.netty.buffer.AbstractByteBuf;
import com.suning.api.link.io.netty.buffer.ByteBuf;
import com.suning.api.link.io.netty.buffer.SwappedByteBuf;
import com.suning.api.link.io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

final class UnsafeDirectSwappedByteBuf
extends SwappedByteBuf {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    UnsafeDirectSwappedByteBuf(AbstractByteBuf buf) {
        super(buf);
        this.wrapped = buf;
        this.nativeByteOrder = NATIVE_ORDER == (this.order() == ByteOrder.BIG_ENDIAN);
    }

    private long addr(int index) {
        return this.wrapped.memoryAddress() + (long)index;
    }

    public long getLong(int index) {
        this.wrapped.checkIndex(index, 8);
        long v = PlatformDependent.getLong(this.addr(index));
        return this.nativeByteOrder ? v : Long.reverseBytes(v);
    }

    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public int getInt(int index) {
        this.wrapped.checkIndex(index, 4);
        int v = PlatformDependent.getInt(this.addr(index));
        return this.nativeByteOrder ? v : Integer.reverseBytes(v);
    }

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public short getShort(int index) {
        this.wrapped.checkIndex(index, 2);
        short v = PlatformDependent.getShort(this.addr(index));
        return this.nativeByteOrder ? v : Short.reverseBytes(v);
    }

    public ByteBuf setShort(int index, int value) {
        this.wrapped.checkIndex(index, 2);
        this._setShort(index, value);
        return this;
    }

    public ByteBuf setInt(int index, int value) {
        this.wrapped.checkIndex(index, 4);
        this._setInt(index, value);
        return this;
    }

    public ByteBuf setLong(int index, long value) {
        this.wrapped.checkIndex(index, 8);
        this._setLong(index, value);
        return this;
    }

    public ByteBuf setChar(int index, int value) {
        this.setShort(index, value);
        return this;
    }

    public ByteBuf setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
        return this;
    }

    public ByteBuf setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
        return this;
    }

    public ByteBuf writeShort(int value) {
        this.wrapped.ensureAccessible();
        this.wrapped.ensureWritable(2);
        this._setShort(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 2;
        return this;
    }

    public ByteBuf writeInt(int value) {
        this.wrapped.ensureAccessible();
        this.wrapped.ensureWritable(4);
        this._setInt(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 4;
        return this;
    }

    public ByteBuf writeLong(long value) {
        this.wrapped.ensureAccessible();
        this.wrapped.ensureWritable(8);
        this._setLong(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 8;
        return this;
    }

    public ByteBuf writeChar(int value) {
        this.writeShort(value);
        return this;
    }

    public ByteBuf writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
        return this;
    }

    public ByteBuf writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
        return this;
    }

    private void _setShort(int index, int value) {
        PlatformDependent.putShort(this.addr(index), this.nativeByteOrder ? (short)value : Short.reverseBytes((short)value));
    }

    private void _setInt(int index, int value) {
        PlatformDependent.putInt(this.addr(index), this.nativeByteOrder ? value : Integer.reverseBytes(value));
    }

    private void _setLong(int index, long value) {
        PlatformDependent.putLong(this.addr(index), this.nativeByteOrder ? value : Long.reverseBytes(value));
    }
}

