/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.channel;

import com.suning.api.link.io.netty.buffer.ByteBuf;
import com.suning.api.link.io.netty.buffer.ByteBufAllocator;
import com.suning.api.link.io.netty.channel.RecvByteBufAllocator;

public class FixedRecvByteBufAllocator
implements RecvByteBufAllocator {
    private final RecvByteBufAllocator.Handle handle;

    public FixedRecvByteBufAllocator(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must greater than 0: " + bufferSize);
        }
        this.handle = new HandleImpl(bufferSize);
    }

    public RecvByteBufAllocator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements RecvByteBufAllocator.Handle {
        private final int bufferSize;

        HandleImpl(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public ByteBuf allocate(ByteBufAllocator alloc) {
            return alloc.ioBuffer(this.bufferSize);
        }

        public int guess() {
            return this.bufferSize;
        }

        public void record(int actualReadBytes) {
        }
    }
}

