/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec;

import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.channel.ChannelInboundHandlerAdapter;
import com.suning.api.link.io.netty.handler.codec.DecoderException;
import com.suning.api.link.io.netty.util.ReferenceCountUtil;
import com.suning.api.link.io.netty.util.internal.RecyclableArrayList;
import com.suning.api.link.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageDecoder.class, "I");
    }

    protected MessageToMessageDecoder(Class<? extends I> inboundMessageType) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        RecyclableArrayList out = RecyclableArrayList.newInstance();
        try {
            try {
                if (this.acceptInboundMessage(msg)) {
                    Object cast = msg;
                    try {
                        this.decode(ctx, cast, out);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        ReferenceCountUtil.release(cast);
                        throw throwable;
                    }
                    ReferenceCountUtil.release(cast);
                }
                out.add(msg);
            }
            catch (DecoderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DecoderException(e);
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            int size = out.size();
            int i = 0;
            while (true) {
                if (i >= size) {
                    out.recycle();
                    throw throwable;
                }
                ctx.fireChannelRead(out.get(i));
                ++i;
            }
        }
        int size = out.size();
        for (int i = 0; i < size; ++i) {
            ctx.fireChannelRead(out.get(i));
        }
        out.recycle();
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

