/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec;

import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.suning.api.link.io.netty.channel.ChannelPromise;
import com.suning.api.link.io.netty.handler.codec.EncoderException;
import com.suning.api.link.io.netty.util.ReferenceCountUtil;
import com.suning.api.link.io.netty.util.internal.RecyclableArrayList;
import com.suning.api.link.io.netty.util.internal.StringUtil;
import com.suning.api.link.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");
    }

    protected MessageToMessageEncoder(Class<? extends I> outboundMessageType) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        RecyclableArrayList out = null;
        try {
            block17: {
                try {
                    if (this.acceptOutboundMessage(msg)) {
                        out = RecyclableArrayList.newInstance();
                        Object cast = msg;
                        try {
                            this.encode(ctx, cast, out);
                            Object var7_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            ReferenceCountUtil.release(cast);
                            throw throwable;
                        }
                        ReferenceCountUtil.release(cast);
                        if (out.isEmpty()) {
                            out.recycle();
                            out = null;
                            throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                        }
                        break block17;
                    }
                    ctx.write(msg, promise);
                }
                catch (EncoderException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new EncoderException(t);
                }
            }
            Object var9_11 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (out == null) throw throwable;
            int sizeMinusOne = out.size() - 1;
            if (sizeMinusOne == 0) {
                ctx.write(out.get(0), promise);
            } else if (sizeMinusOne > 0) {
                ChannelPromise voidPromise = ctx.voidPromise();
                boolean isVoidPromise = promise == voidPromise;
                for (int i = 0; i < sizeMinusOne; ++i) {
                    ChannelPromise p = isVoidPromise ? voidPromise : ctx.newPromise();
                    ctx.write(out.get(i), p);
                }
                ctx.write(out.get(sizeMinusOne), promise);
            }
            out.recycle();
            throw throwable;
        }
        int sizeMinusOne = out.size() - 1;
        if (sizeMinusOne == 0) {
            ctx.write(out.get(0), promise);
        } else if (sizeMinusOne > 0) {
            ChannelPromise voidPromise = ctx.voidPromise();
            boolean isVoidPromise = promise == voidPromise;
            for (int i = 0; i < sizeMinusOne; ++i) {
                ChannelPromise p = isVoidPromise ? voidPromise : ctx.newPromise();
                ctx.write(out.get(i), p);
            }
            ctx.write(out.get(sizeMinusOne), promise);
        }
        out.recycle();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

