/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec.http.websocketx;

import com.suning.api.link.io.netty.channel.ChannelFuture;
import com.suning.api.link.io.netty.channel.ChannelFutureListener;
import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.channel.ChannelInboundHandlerAdapter;
import com.suning.api.link.io.netty.handler.codec.http.FullHttpResponse;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;

class WebSocketClientProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketClientHandshaker handshaker;

    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.handshaker.handshake(ctx.channel()).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ctx.fireExceptionCaught(future.cause());
                } else {
                    ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_ISSUED);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof FullHttpResponse)) {
            ctx.fireChannelRead(msg);
            return;
        }
        FullHttpResponse response = (FullHttpResponse)msg;
        try {
            if (this.handshaker.isHandshakeComplete()) throw new IllegalStateException("WebSocketClientHandshaker should have been non finished yet");
            this.handshaker.finishHandshake(ctx.channel(), response);
            ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE);
            ctx.pipeline().remove(this);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            response.release();
            throw throwable;
        }
        response.release();
    }
}

