/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.parse;

import com.suning.api.SuningRequest;
import com.suning.api.SuningResponse;
import com.suning.api.exception.SuningApiException;
import com.suning.api.parse.Parse;
import com.suning.api.parse.ParseFactory;
import com.suning.api.util.XmlUtil;
import com.suning.api.util.json.mapping.Converters;
import com.suning.api.util.json.mapping.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParse
implements Parse {
    public <T extends SuningResponse> T parse(String paramString, Class<T> paramClass) throws SuningApiException {
        Element root = XmlUtil.getRootElementFromString(paramString);
        return (T)((SuningResponse)this.getModelFromXML(root, paramClass));
    }

    private <T> T getModelFromXML(final Element element, Class<T> clazz) throws SuningApiException {
        if (element == null) {
            return null;
        }
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                Element childE = XmlUtil.getChildElement(element, (String)name);
                return childE != null;
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return XmlUtil.getElementValue(element, (String)name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws SuningApiException {
                Element childE = XmlUtil.getChildElement(element, (String)name);
                if (childE != null) {
                    return XmlParse.this.getModelFromXML(childE, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object itemName, Class<?> subType) throws SuningApiException {
                ArrayList<String> list = null;
                Element listE = XmlUtil.getChildElement(element, (String)itemName);
                if (listE != null) {
                    list = new ArrayList<String>();
                    List<Element> itemEs = XmlUtil.getChildElements(listE, (String)itemName);
                    for (Element itemE : itemEs) {
                        Object obj = null;
                        String value = XmlUtil.getElementValue(itemE);
                        if (String.class.isAssignableFrom(subType)) {
                            obj = value;
                        } else if (Long.class.isAssignableFrom(subType)) {
                            obj = Long.valueOf(value);
                        } else if (Integer.class.isAssignableFrom(subType)) {
                            obj = Integer.valueOf(value);
                        } else if (Boolean.class.isAssignableFrom(subType)) {
                            obj = Boolean.valueOf(value);
                        } else if (Date.class.isAssignableFrom(subType)) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                obj = format.parse(value);
                            }
                            catch (ParseException e) {
                                throw new SuningApiException(e);
                            }
                        } else {
                            obj = XmlParse.this.getModelFromXML(itemE, subType);
                        }
                        if (obj == null) continue;
                        list.add((String)obj);
                    }
                }
                return list;
            }
        });
    }

    @Override
    public <T extends SuningResponse> T parseToResponse(String paramString, Class<T> paramClass) throws SuningApiException {
        Map<String, Object> rspMap = XmlUtil.parseXmlToMap(paramString);
        Collection<Object> values = rspMap.values();
        for (Object rspObj : values) {
            if (!(rspObj instanceof Map)) continue;
            Map rspJson = (Map)rspObj;
            SuningResponse t = (SuningResponse)ParseFactory.getMapParse("map").fromMapToObject(rspJson, paramClass);
            t.setRspMap(rspMap);
            return (T)t;
        }
        return null;
    }

    @Override
    public <T extends SuningRequest<? extends SuningResponse>> T parseToRequest(String paramString, Class<T> paramClass) throws SuningApiException {
        Map<String, Object> rspMap = XmlUtil.parseXmlToMap(paramString);
        T t = ParseFactory.getMapParse("map").parseMapToRequest(rspMap, paramClass);
        return t;
    }
}

