/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util;

import com.suning.api.SuningRequest;
import com.suning.api.SuningResponse;
import com.suning.api.annotation.APIParamsCheck;
import com.suning.api.annotation.ApiField;
import com.suning.api.exception.SuningApiCheckException;
import com.suning.api.exception.SuningApiException;
import com.suning.api.parse.MapParse;
import com.suning.api.parse.Parse;
import com.suning.api.parse.ParseFactory;
import com.suning.api.util.StringUtil;
import com.suning.api.util.vilidator.IFieldValidator;
import com.suning.api.util.vilidator.ValidatorFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckUtil {
    public static <T extends SuningRequest<? extends SuningResponse>> void checkApiParam(T requestObj, String format) throws SuningApiException {
        String resparamsInputType = requestObj.getResparamsInputType();
        if (requestObj.isCheckParam()) {
            Object parse;
            SuningRequest<Object> newReqObj = null;
            if ("map".equalsIgnoreCase(resparamsInputType) && null != requestObj.getResParamsMap()) {
                parse = ParseFactory.getMapParse("map");
                try {
                    newReqObj = (SuningRequest<Object>)((MapParse)parse).parseMapToRequest(requestObj.getResParamsMap(), requestObj.getClass());
                    newReqObj.setAppMethod(requestObj.getAppMethod());
                    newReqObj.setAppRequestTime(requestObj.getAppRequestTime());
                    newReqObj.setCheckParam(requestObj.isCheckParam());
                    newReqObj.setResparams(requestObj.getResParams());
                    newReqObj.setResParamsMap(requestObj.getResParamsMap());
                    newReqObj.setSignInfo(requestObj.getSignInfo());
                }
                catch (SuningApiException e) {
                    throw new SuningApiException(e);
                }
            }
            if ("string".equalsIgnoreCase(resparamsInputType) && !StringUtil.isEmpty(requestObj.getResParams())) {
                parse = ParseFactory.getParse(requestObj.getReqFormat());
                try {
                    newReqObj = parse.parseToRequest(requestObj.getResParams(), requestObj.getClass());
                    newReqObj.setAppMethod(requestObj.getAppMethod());
                    newReqObj.setAppRequestTime(requestObj.getAppRequestTime());
                    newReqObj.setCheckParam(requestObj.isCheckParam());
                    newReqObj.setResparams(requestObj.getResParams());
                    newReqObj.setResParamsMap(requestObj.getResParamsMap());
                    newReqObj.setSignInfo(requestObj.getSignInfo());
                }
                catch (SuningApiException e) {
                    throw new SuningApiException(e);
                }
            }
            try {
                if (null == newReqObj) {
                    CheckUtil.checkObject(requestObj);
                } else {
                    CheckUtil.checkObject(newReqObj);
                }
            }
            catch (SuningApiCheckException e) {
                throw new SuningApiCheckException(e.getMessage());
            }
        }
    }

    private static <T extends SuningRequest<? extends SuningResponse>> void checkObject(T requestObj) throws SuningApiException {
        if (null == requestObj) {
            return;
        }
        Field[] fields = requestObj.getClass().getDeclaredFields();
        if (null != fields) {
            for (Field field : fields) {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    try {
                        Object fieldValue = field.get(requestObj);
                        CheckUtil.doValidCheck(fieldValue, field, requestObj.getBizName());
                        if (fieldValue instanceof Boolean || fieldValue instanceof Number || fieldValue instanceof String || fieldValue instanceof Character || fieldValue instanceof Date || null == fieldValue || !fieldValue.getClass().isArray()) continue;
                        CheckUtil.checkArray(fieldValue, requestObj.getBizName());
                    }
                    catch (IllegalAccessException e) {
                        throw new SuningApiException(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new SuningApiException(e);
                }
            }
        }
    }

    private static void checkArray(Object object, String apiBizName) throws SuningApiException {
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            try {
                CheckUtil.doCheck(Array.get(object, i), apiBizName);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SuningApiException(e);
            }
            catch (IllegalArgumentException e) {
                throw new SuningApiException(e);
            }
        }
    }

    private static void doCheck(Object obj, String apiBizName) throws SuningApiException {
        if (null == obj) {
            return;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        if (null != fields) {
            for (Field field : fields) {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    try {
                        Object fieldValue = field.get(obj);
                        CheckUtil.doValidCheck(fieldValue, field, apiBizName);
                        if (fieldValue instanceof Boolean || fieldValue instanceof Number || fieldValue instanceof String || fieldValue instanceof Character || fieldValue instanceof Date || null == fieldValue || !fieldValue.getClass().isArray()) continue;
                        CheckUtil.checkArray(fieldValue, apiBizName);
                    }
                    catch (IllegalAccessException e) {
                        throw new SuningApiException(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new SuningApiException(e);
                }
            }
        }
    }

    private static void doValidCheck(Object object, Field field, String apiBizName) throws SuningApiException {
        APIParamsCheck apiParamsCheck = field.getAnnotation(APIParamsCheck.class);
        if (null == apiParamsCheck) {
            return;
        }
        String[] vilidatorTypes = apiParamsCheck.vilidatorType();
        int index = 0;
        for (String vilidatorType : vilidatorTypes) {
            IFieldValidator validator;
            String param = "";
            if (apiParamsCheck.params() != null && apiParamsCheck.params().length > index) {
                param = apiParamsCheck.params()[index];
            }
            if (!(validator = ValidatorFactory.getValidator(vilidatorType, param)).validate(object, field)) {
                String[] errorCodes = apiParamsCheck.errorCode();
                if (null != errorCodes && errorCodes.length > 0) {
                    throw new SuningApiCheckException(errorCodes[index]);
                }
                String fieldName = field.getName();
                ApiField jsonField = field.getAnnotation(ApiField.class);
                if (null != jsonField) {
                    fieldName = jsonField.alias();
                }
                StringBuilder validBuilder = new StringBuilder();
                validBuilder.append("biz.");
                validBuilder.append(apiBizName);
                if ("required".equals(vilidatorType)) {
                    validBuilder.append(".missing-parameter:");
                } else if ("regex".equals(vilidatorType)) {
                    validBuilder.append(".invalid_parameter:");
                }
                validBuilder.append(fieldName);
                throw new SuningApiCheckException(validBuilder.toString());
            }
            ++index;
        }
    }

    public static <T extends SuningResponse> T constructErrorResponse(SuningRequest<T> paramSuningRequest, String errorMessage, String format) throws SuningApiException {
        Class<T> clazz = paramSuningRequest.getResponseClass();
        try {
            SuningResponse rspObj = (SuningResponse)clazz.newInstance();
            StringBuilder builder = new StringBuilder();
            if ("xml".equalsIgnoreCase(format)) {
                builder.append("<sn_responseContent><sn_error>");
                builder.append("<error_code>");
                builder.append(errorMessage);
                builder.append("</error_code>");
                builder.append("</sn_error></sn_responseContent>");
            } else if ("json".equalsIgnoreCase(format)) {
                builder.append("{\"sn_responseContent\":{");
                builder.append("\"sn_error\":{\"error_code\":");
                builder.append("\"");
                builder.append(errorMessage);
                builder.append("\"");
                builder.append("}}}");
            }
            String errorResponseData = builder.toString();
            Parse parse = ParseFactory.getParse(format);
            rspObj = parse.parseToResponse(errorResponseData, paramSuningRequest.getResponseClass());
            rspObj.setBody(errorResponseData);
            rspObj.setReqParam(paramSuningRequest.getResParams());
            return (T)rspObj;
        }
        catch (InstantiationException e) {
            throw new SuningApiException(e);
        }
        catch (IllegalAccessException e) {
            throw new SuningApiException(e);
        }
    }
}

