/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class NetUtil {
    private static final Pattern IP_PATTERN;
    private static final String LOCAL_IP_ADDRESS;

    public static String getLocalAddress() {
        return LOCAL_IP_ADDRESS;
    }

    private static String getFirstLocalAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().contains(":")) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !"0.0.0.0".equals(name) && !"127.0.0.1".equals(name) && IP_PATTERN.matcher(name).matches();
    }

    static {
        InetAddress localAddress;
        IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            localAddress = null;
        }
        LOCAL_IP_ADDRESS = localAddress != null && NetUtil.isValidAddress(localAddress) ? localAddress.getHostAddress() : NetUtil.getFirstLocalAddress();
    }
}

