/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util.json.mapping;

import com.suning.api.SelectSuningRequest;
import com.suning.api.SelectSuningResponse;
import com.suning.api.SuningUploadRequest;
import com.suning.api.SuningUploadResponse;
import com.suning.api.annotation.ApiField;
import com.suning.api.exception.SuningApiException;
import com.suning.api.util.StringUtil;
import com.suning.api.util.json.mapping.Reader;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Set<String> BASEFIELDS = new HashSet<String>();
    private static final Set<String> BASEUPLOADFIELDS = new HashSet<String>();
    private static final Set<String> BASESELECTFIELDS = new HashSet<String>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws SuningApiException {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                Object value;
                Field field;
                ApiField jsonField;
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                String itemName = pd.getName();
                Object listName = null;
                Class<T> superClazz = clazz.getSuperclass();
                if (SelectSuningRequest.class.getName().equalsIgnoreCase(superClazz.getName()) || SuningUploadRequest.class.getName().equalsIgnoreCase(superClazz.getName()) || SelectSuningResponse.class.getName().equalsIgnoreCase(superClazz.getName()) || SuningUploadResponse.class.getName().equalsIgnoreCase(superClazz.getName())) {
                    superClazz = superClazz.getSuperclass();
                }
                if ((jsonField = (field = BASEFIELDS.contains(itemName) ? superClazz.getDeclaredField(itemName) : (BASEUPLOADFIELDS.contains(itemName) && clazz.getName().indexOf("Request") != -1 ? clazz.getSuperclass().getDeclaredField(itemName) : (BASESELECTFIELDS.contains(itemName) && clazz.getName().indexOf("Request") != -1 ? clazz.getSuperclass().getDeclaredField(itemName) : clazz.getDeclaredField(itemName)))).getAnnotation(ApiField.class)) != null) {
                    itemName = jsonField.alias();
                }
                if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                Class<?> typeClass = field.getType();
                if (String.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof String) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new SuningApiException(itemName + " is not a String");
                    }
                    if (value != null) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    method.invoke(rsp, "");
                    continue;
                }
                if (Long.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Long) {
                        method.invoke(rsp, (Long)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new SuningApiException(itemName + " is not a Number(Long)");
                    }
                    if (!StringUtil.isNumeric(value)) continue;
                    method.invoke(rsp, Long.valueOf(value.toString()));
                    continue;
                }
                if (Integer.class.isAssignableFrom(typeClass) || Integer.TYPE.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Integer) {
                        method.invoke(rsp, (Integer)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new SuningApiException(itemName + " is not a Number(Integer)");
                    }
                    if (!StringUtil.isNumeric(value)) continue;
                    method.invoke(rsp, Integer.valueOf(value.toString()));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Boolean) {
                        method.invoke(rsp, (Boolean)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new SuningApiException(itemName + " is not a Boolean");
                    }
                    if (value == null) continue;
                    method.invoke(rsp, Boolean.valueOf(value.toString()));
                    continue;
                }
                if (Double.class.isAssignableFrom(typeClass) || Double.TYPE.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    method.invoke(rsp, Double.parseDouble(String.valueOf(value)));
                    continue;
                }
                if (Number.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Number) {
                        method.invoke(rsp, (Number)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new SuningApiException(itemName + " is not a Number");
                }
                if (Date.class.isAssignableFrom(typeClass)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    Object value2 = reader.getPrimitiveObject(itemName);
                    if (!(value2 instanceof String)) continue;
                    method.invoke(rsp, format.parse(value2.toString()));
                    continue;
                }
                if (List.class.isAssignableFrom(typeClass)) {
                    Class subType;
                    List<?> listObjs;
                    ParameterizedType paramType;
                    Type[] genericTypes;
                    Type fieldType = field.getGenericType();
                    if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || null == (listObjs = reader.getListObjects(itemName, subType = (Class)genericTypes[0]))) continue;
                    method.invoke(rsp, listObjs);
                    continue;
                }
                Object obj = reader.getObject(itemName, typeClass);
                if (obj == null) continue;
                method.invoke(rsp, obj);
            }
        }
        catch (Exception e) {
            throw new SuningApiException(e);
        }
        return rsp;
    }

    static {
        BASEFIELDS.add("code");
        BASEFIELDS.add("body");
        BASEFIELDS.add("rspMap");
        BASEFIELDS.add("reqParam");
        BASEFIELDS.add("sysParams");
        BASESELECTFIELDS.add("pageNo");
        BASESELECTFIELDS.add("pageSize");
        BASEFIELDS.add("appRequestTime");
        BASEFIELDS.add("appMethod");
        BASEFIELDS.add("signInfo");
        BASEFIELDS.add("reqFormat");
        BASEFIELDS.add("resparamsInputType");
        BASEFIELDS.add("checkParam");
        BASEFIELDS.add("resParamsMap");
        BASEFIELDS.add("resparams");
        BASEUPLOADFIELDS.add("picContent");
    }
}

