/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.douyu.api;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.Header;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpStatus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.dto.GiftListInfo;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.dto.GiftPropSingle;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrJacksonUtil;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCollUtil;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatHttpUtil;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatLocalDateTimeUtil;

public class DouyuApis {
    private static final Logger log = LoggerFactory.getLogger(DouyuApis.class);
    public static final TimedCache<String, GiftPropSingle> giftMap = new TimedCache(TimeUnit.DAYS.toMillis(1L));
    public static final TimedCache<String, Map<Long, GiftListInfo>> roomGiftMap = new TimedCache(TimeUnit.DAYS.toMillis(1L), new HashMap());
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String PATTERN_BODY_ROOM_ID = "\\$ROOM\\.room_id\\D+(\\d+)";
    public static final String KEY_REDIRECT_LOCATION_RID = "rid";
    public static final String KEY_COOKIE_DY_DID = "dy_did";
    public static final String KEY_COOKIE_ACF_UID = "acf_uid";
    public static final String KEY_COOKIE_ACF_STK = "acf_stk";
    public static final String KEY_COOKIE_ACF_LTKID = "acf_ltkid";
    public static final String API_AVATAR = "https://apic.douyucdn.cn/upload/";
    public static final String API_GIFT_LIST = "https://gift.douyucdn.cn/api/gift/v3/web/list?rid=";
    public static final String API_PROP_SINGLE = "https://gift.douyucdn.cn/api/prop/v1/web/single?pid=";
    public static final String API_SERVER_INFO = "https://www.douyu.com/lapi/live/gateway/web/";
    public static final String API_AVATAR_PREFIX_SMALL = "_small.jpg";
    public static final String API_AVATAR_PREFIX_MIDDLE = "_middle.jpg";
    public static final String API_AVATAR_PREFIX_BIG = "_big.jpg";
    public static final String vk_secret = "r5*^5;}2#${XF[h+;'./.Q'1;,-]f'p[";

    public static String getAvatarUrl(List<String> list, String prefix) {
        if (CollUtil.isEmpty(list) || list.size() < 3) {
            return "";
        }
        return API_AVATAR + CollUtil.join(list, (CharSequence)"/") + prefix;
    }

    public static String getSmallAvatarUrl(List<String> list) {
        return DouyuApis.getAvatarUrl(list, API_AVATAR_PREFIX_SMALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRealRoomId(long roomId, String cookie) {
        String realRoomIdString = null;
        HttpResponse execute = OrLiveChatHttpUtil.createGet((String)("https://www.douyu.com/" + roomId)).cookie(cookie).execute();
        try {
            String body;
            String matchString;
            String location;
            Map paramMap;
            if (execute.getStatus() == 404) {
                throw new BaseException("\u83b7\u53d6" + roomId + "\u771f\u5b9e\u623f\u95f4ID\u5931\u8d25");
            }
            if (HttpStatus.isRedirected((int)execute.getStatus()) && (paramMap = OrLiveChatHttpUtil.decodeParamMap((String)(location = execute.header(Header.LOCATION)), null)).containsKey(KEY_REDIRECT_LOCATION_RID)) {
                realRoomIdString = (String)paramMap.get(KEY_REDIRECT_LOCATION_RID);
            }
            if (StrUtil.isBlank(realRoomIdString) && StrUtil.isNotBlank((CharSequence)(matchString = ReUtil.get((String)PATTERN_BODY_ROOM_ID, (CharSequence)(body = execute.body()), (int)1)))) {
                realRoomIdString = matchString;
            }
            long realRoomId = roomId;
            if (!StrUtil.isBlank(realRoomIdString)) {
                try {
                    realRoomId = NumberUtil.parseLong(realRoomIdString);
                }
                catch (Exception e) {
                    throw new BaseException("\u83b7\u53d6" + roomId + "\u771f\u5b9e\u623f\u95f4ID\u5931\u8d25");
                }
            }
            long l = realRoomId;
            return l;
        }
        finally {
            if (Collections.singletonList(execute).get(0) != null) {
                execute.close();
            }
        }
    }

    public static long getRealRoomId(long roomId) {
        return DouyuApis.getRealRoomId(roomId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerInfoResult getServerInfo(long roomId, String cookie) {
        ServerInfoResult serverInfoResult;
        block6: {
            HttpResponse execute = OrLiveChatHttpUtil.createPost((String)(API_SERVER_INFO + roomId + "?isH5=1")).cookie(cookie).execute();
            try {
                JsonNode jsonNode = DouyuApis.responseInterceptor(execute.body());
                serverInfoResult = (ServerInfoResult)OrJacksonUtil.getInstance().readValue(jsonNode.toString(), ServerInfoResult.class);
                if (Collections.singletonList(execute).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(execute).get(0) != null) {
                    execute.close();
                }
                throw throwable;
            }
            execute.close();
        }
        return serverInfoResult;
    }

    public static ServerInfoResult getServerInfo(long roomId) {
        return DouyuApis.getServerInfo(roomId, null);
    }

    public static String getRandomWssUri(long roomId) {
        ServerInfoResult serverInfoResult = DouyuApis.getServerInfo(roomId);
        List<Wss> wssList = serverInfoResult.getWss();
        Wss randomWss = (Wss)OrLiveChatCollUtil.getRandom(wssList);
        return "wss://" + randomWss.getDomain() + ":" + randomWss.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GiftListResult getGiftList(long roomId) {
        GiftListResult giftListResult;
        block6: {
            HttpResponse execute = OrLiveChatHttpUtil.createGet((String)(API_GIFT_LIST + roomId)).execute();
            try {
                JsonNode jsonNode = DouyuApis.responseInterceptor(execute.body());
                giftListResult = (GiftListResult)OrJacksonUtil.getInstance().readValue(jsonNode.toString(), GiftListResult.class);
                if (Collections.singletonList(execute).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(execute).get(0) != null) {
                    execute.close();
                }
                throw throwable;
            }
            execute.close();
        }
        return giftListResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GiftPropSingle getGiftPropSingleByPid(String pid) {
        GiftPropSingle giftPropSingle;
        block6: {
            HttpResponse execute = OrLiveChatHttpUtil.createGet((String)(API_PROP_SINGLE + pid)).execute();
            try {
                JsonNode jsonNode = DouyuApis.responseInterceptor(execute.body());
                giftPropSingle = (GiftPropSingle)OrJacksonUtil.getInstance().readValue(jsonNode.toString(), GiftPropSingle.class);
                if (Collections.singletonList(execute).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(execute).get(0) != null) {
                    execute.close();
                }
                throw throwable;
            }
            execute.close();
        }
        return giftPropSingle;
    }

    public static String generateVk(long currentTimeSecs, String did) {
        return MD5.create().digestHex(currentTimeSecs + vk_secret + did);
    }

    public static String generateVk(String did) {
        return DouyuApis.generateVk(OrLiveChatLocalDateTimeUtil.zonedCurrentTimeSecs(), did);
    }

    public static Map<Long, GiftListInfo> updateRoomGiftMapCache(long roomId) {
        HashMap<Long, GiftListInfo> map = new HashMap<Long, GiftListInfo>();
        List<GiftListInfo> giftList = DouyuApis.getGiftList(roomId).getGiftList();
        CollUtil.forEach(giftList, (CollUtil.Consumer & Serializable)(giftListInfo, index) -> {
            block2: {
                try {
                    map.put(giftListInfo.getId(), (GiftListInfo)giftListInfo);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("\u83b7\u53d6\u623f\u95f4\u793c\u7269\u5217\u8868\u5f02\u5e38", (Throwable)e);
                }
            }
        });
        roomGiftMap.put((Object)String.valueOf(DouyuApis.getRealRoomId(roomId)), map);
        return map;
    }

    private static JsonNode responseInterceptor(String responseString) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseString);
            int code = jsonNode.get("error").asInt();
            if (code == 0) {
                return jsonNode.get("data");
            }
            throw new BaseException(jsonNode.get("msg").asText());
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static class ServerInfoResult {
        private List<Gateway> gateway;
        private List<Wss> wss;
        private int ir;

        public List<Gateway> getGateway() {
            return this.gateway;
        }

        public List<Wss> getWss() {
            return this.wss;
        }

        public int getIr() {
            return this.ir;
        }

        public void setGateway(List<Gateway> gateway) {
            this.gateway = gateway;
        }

        public void setWss(List<Wss> wss) {
            this.wss = wss;
        }

        public void setIr(int ir) {
            this.ir = ir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerInfoResult)) {
                return false;
            }
            ServerInfoResult other = (ServerInfoResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIr() != other.getIr()) {
                return false;
            }
            List<Gateway> this$gateway = this.getGateway();
            List<Gateway> other$gateway = other.getGateway();
            if (this$gateway == null ? other$gateway != null : !((Object)this$gateway).equals(other$gateway)) {
                return false;
            }
            List<Wss> this$wss = this.getWss();
            List<Wss> other$wss = other.getWss();
            return !(this$wss == null ? other$wss != null : !((Object)this$wss).equals(other$wss));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerInfoResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIr();
            List<Gateway> $gateway = this.getGateway();
            result = result * 59 + ($gateway == null ? 43 : ((Object)$gateway).hashCode());
            List<Wss> $wss = this.getWss();
            result = result * 59 + ($wss == null ? 43 : ((Object)$wss).hashCode());
            return result;
        }

        public String toString() {
            return "DouyuApis.ServerInfoResult(gateway=" + this.getGateway() + ", wss=" + this.getWss() + ", ir=" + this.getIr() + ")";
        }

        public ServerInfoResult(List<Gateway> gateway, List<Wss> wss, int ir) {
            this.gateway = gateway;
            this.wss = wss;
            this.ir = ir;
        }

        public ServerInfoResult() {
        }
    }

    public static class Wss {
        private String domain;
        private int port;

        public String getDomain() {
            return this.domain;
        }

        public int getPort() {
            return this.port;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wss)) {
                return false;
            }
            Wss other = (Wss)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            return !(this$domain == null ? other$domain != null : !this$domain.equals(other$domain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Wss;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            return result;
        }

        public String toString() {
            return "DouyuApis.Wss(domain=" + this.getDomain() + ", port=" + this.getPort() + ")";
        }

        public Wss(String domain, int port) {
            this.domain = domain;
            this.port = port;
        }

        public Wss() {
        }
    }

    public static class GiftListResult {
        private List<GiftListInfo> giftList;
        private long onceLimit;
        private JsonNode skinData;
        private JsonNode tabs;
        private String tid;

        public List<GiftListInfo> getGiftList() {
            return this.giftList;
        }

        public long getOnceLimit() {
            return this.onceLimit;
        }

        public JsonNode getSkinData() {
            return this.skinData;
        }

        public JsonNode getTabs() {
            return this.tabs;
        }

        public String getTid() {
            return this.tid;
        }

        public void setGiftList(List<GiftListInfo> giftList) {
            this.giftList = giftList;
        }

        public void setOnceLimit(long onceLimit) {
            this.onceLimit = onceLimit;
        }

        public void setSkinData(JsonNode skinData) {
            this.skinData = skinData;
        }

        public void setTabs(JsonNode tabs) {
            this.tabs = tabs;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GiftListResult)) {
                return false;
            }
            GiftListResult other = (GiftListResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOnceLimit() != other.getOnceLimit()) {
                return false;
            }
            List<GiftListInfo> this$giftList = this.getGiftList();
            List<GiftListInfo> other$giftList = other.getGiftList();
            if (this$giftList == null ? other$giftList != null : !((Object)this$giftList).equals(other$giftList)) {
                return false;
            }
            JsonNode this$skinData = this.getSkinData();
            JsonNode other$skinData = other.getSkinData();
            if (this$skinData == null ? other$skinData != null : !this$skinData.equals(other$skinData)) {
                return false;
            }
            JsonNode this$tabs = this.getTabs();
            JsonNode other$tabs = other.getTabs();
            if (this$tabs == null ? other$tabs != null : !this$tabs.equals(other$tabs)) {
                return false;
            }
            String this$tid = this.getTid();
            String other$tid = other.getTid();
            return !(this$tid == null ? other$tid != null : !this$tid.equals(other$tid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GiftListResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $onceLimit = this.getOnceLimit();
            result = result * 59 + (int)($onceLimit >>> 32 ^ $onceLimit);
            List<GiftListInfo> $giftList = this.getGiftList();
            result = result * 59 + ($giftList == null ? 43 : ((Object)$giftList).hashCode());
            JsonNode $skinData = this.getSkinData();
            result = result * 59 + ($skinData == null ? 43 : $skinData.hashCode());
            JsonNode $tabs = this.getTabs();
            result = result * 59 + ($tabs == null ? 43 : $tabs.hashCode());
            String $tid = this.getTid();
            result = result * 59 + ($tid == null ? 43 : $tid.hashCode());
            return result;
        }

        public String toString() {
            return "DouyuApis.GiftListResult(giftList=" + this.getGiftList() + ", onceLimit=" + this.getOnceLimit() + ", skinData=" + this.getSkinData() + ", tabs=" + this.getTabs() + ", tid=" + this.getTid() + ")";
        }

        public GiftListResult(List<GiftListInfo> giftList, long onceLimit, JsonNode skinData, JsonNode tabs, String tid) {
            this.giftList = giftList;
            this.onceLimit = onceLimit;
            this.skinData = skinData;
            this.tabs = tabs;
            this.tid = tid;
        }

        public GiftListResult() {
        }
    }

    public static class Gateway {
        private String ip;
        private int port;

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Gateway)) {
                return false;
            }
            Gateway other = (Gateway)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Gateway;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            return result;
        }

        public String toString() {
            return "DouyuApis.Gateway(ip=" + this.getIp() + ", port=" + this.getPort() + ")";
        }

        public Gateway(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }

        public Gateway() {
        }
    }
}

