/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.douyu.msg.factory;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import tech.ordinaryroad.live.chat.client.codec.douyu.api.DouyuApis;
import tech.ordinaryroad.live.chat.client.codec.douyu.constant.DouyuClientModeEnum;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.ChatmessageMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.HeartbeatMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.JoingroupMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.KeepliveMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.LoginreqMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.SubMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.base.BaseDouyuCmdMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.util.DouyuCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;

public class DouyuMsgFactory {
    private static final TimedCache<Long, DouyuMsgFactory> FACTORY_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L), new ConcurrentHashMap());
    private final long roomId;
    private static volatile HeartbeatMsg heartbeatMsg;

    public DouyuMsgFactory(long roomId) {
        this.roomId = roomId;
    }

    public static DouyuMsgFactory getInstance(long roomId) {
        if (!FACTORY_CACHE.containsKey((Object)roomId)) {
            FACTORY_CACHE.put((Object)roomId, (Object)new DouyuMsgFactory(roomId));
        }
        return (DouyuMsgFactory)FACTORY_CACHE.get((Object)roomId);
    }

    public ByteBuf createAuth(DouyuClientModeEnum mode, String ver, String aver, String cookie) {
        try {
            long realRoomId = DouyuApis.getRealRoomId(this.roomId);
            Map cookieMap = OrLiveChatCookieUtil.parseCookieString((String)cookie);
            if (cookieMap.isEmpty()) {
                if (mode == DouyuClientModeEnum.DANMU) {
                    long uid = RandomUtil.randomInt((int)10000, (int)19999);
                    String username = "visitor" + RandomUtil.randomInt((int)1000000000, (int)1999999999);
                    LoginreqMsg loginreqMsg = new LoginreqMsg(realRoomId, "", username, uid, ver, aver);
                    return DouyuCodecUtil.encode(loginreqMsg, LoginreqMsg.SHOULD_IGNORE_PROPERTIES_WHEN_NOT_LOGGED_IN);
                }
                LoginreqMsg loginreqMsg = new LoginreqMsg(realRoomId, "", "", ver, aver, "", "", "", UUID.fastUUID().toString(true));
                return DouyuCodecUtil.encode(loginreqMsg, LoginreqMsg.SHOULD_IGNORE_PROPERTIES_WHEN_LOGGED_IN);
            }
            String acfUid = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)"acf_uid", () -> {
                throw new BaseException("Cookie\u4e2d\u7f3a\u5c11\u5b57\u6bb5acf_uid");
            });
            long uid = NumberUtil.parseLong((String)acfUid);
            String username = acfUid;
            String dfl = "sn@A=105@Sss@A=1";
            if (mode == DouyuClientModeEnum.DANMU) {
                LoginreqMsg loginreqMsg = new LoginreqMsg(realRoomId, dfl, username, uid, ver, aver);
                return DouyuCodecUtil.encode(loginreqMsg, LoginreqMsg.SHOULD_IGNORE_PROPERTIES_WHEN_NOT_LOGGED_IN);
            }
            String acfLtkid = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)"acf_ltkid", () -> {
                throw new BaseException("Cookie\u4e2d\u7f3a\u5c11\u5b57\u6bb5acf_ltkid");
            });
            String acfStk = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)"acf_stk", () -> {
                throw new BaseException("Cookie\u4e2d\u7f3a\u5c11\u5b57\u6bb5acf_stk");
            });
            String dyDid = OrLiveChatCookieUtil.getCookieByName((Map)cookieMap, (String)"dy_did", () -> {
                throw new BaseException("Cookie\u4e2d\u7f3a\u5c11\u5b57\u6bb5dy_did");
            });
            LoginreqMsg loginreqMsg = new LoginreqMsg(realRoomId, dfl, username, ver, aver, acfLtkid, "1", acfStk, dyDid);
            return DouyuCodecUtil.encode(loginreqMsg, LoginreqMsg.SHOULD_IGNORE_PROPERTIES_WHEN_LOGGED_IN);
        }
        catch (Exception e) {
            throw new BaseException(String.format("\u8ba4\u8bc1\u5305\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u623f\u95f4\u53f7\u662f\u5426\u6b63\u786e\u3002roomId: %d, msg: %s", this.roomId, e.getMessage()));
        }
    }

    public ByteBuf createAuth(DouyuClientModeEnum mode, String ver, String aver) {
        return this.createAuth(mode, ver, aver, null);
    }

    public ByteBuf createHeartbeat() {
        return DouyuCodecUtil.encode(this.getHeartbeatMsg());
    }

    public ByteBuf createKeeplive(String cookie) {
        return DouyuCodecUtil.encode(this.getKeepliveMsg(StrUtil.isNotBlank((CharSequence)cookie) ? "hs-h5" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeartbeatMsg getHeartbeatMsg() {
        if (heartbeatMsg == null) {
            DouyuMsgFactory douyuMsgFactory = this;
            synchronized (douyuMsgFactory) {
                if (heartbeatMsg == null) {
                    heartbeatMsg = new HeartbeatMsg();
                }
            }
        }
        return heartbeatMsg;
    }

    private BaseDouyuCmdMsg getKeepliveMsg(String cnd) {
        return new KeepliveMsg(cnd);
    }

    public ByteBuf createJoingroup() {
        JoingroupMsg joingroupMsg = new JoingroupMsg();
        joingroupMsg.setRid(this.roomId);
        return DouyuCodecUtil.encode(joingroupMsg);
    }

    public ByteBuf createSub() {
        return DouyuCodecUtil.encode(new SubMsg());
    }

    public ByteBuf createDanmu(String msg, String cookie) {
        String dyDid = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)"dy_did", () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570dy_did");
        });
        String acfUid = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)"acf_uid", () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570acf_uid");
        });
        ChatmessageMsg chatmessageMsg = new ChatmessageMsg(msg, dyDid, acfUid);
        return DouyuCodecUtil.encode(chatmessageMsg);
    }
}

