/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.douyu.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.douyu.api.DouyuApis;
import tech.ordinaryroad.live.chat.client.codec.douyu.constant.DouyuCmdEnum;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.DgbMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.DouyuCmdMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.HeartbeatMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.HeartbeatReplyMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.base.BaseDouyuCmdMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.base.IDouyuMsg;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.dto.GiftListInfo;
import tech.ordinaryroad.live.chat.client.codec.douyu.msg.dto.GiftPropSingle;
import tech.ordinaryroad.live.chat.client.commons.util.OrJacksonUtil;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatReflectUtil;

public class DouyuCodecUtil {
    private static final Logger log = LoggerFactory.getLogger(DouyuCodecUtil.class);
    public static final String[] IGNORE_PROPERTIES = new String[]{"OBJECT_MAPPER", "unknownProperties"};
    public static final String SHOULD_IGNORE_PROPERTIES_PREFIX = "SHOULD_IGNORE";
    public static final short MSG_TYPE_SEND = 689;
    public static final short MSG_TYPE_RECEIVE = 690;
    public static final short FRAME_HEADER_LENGTH = 8;
    public static final String SPLITTER = "@=";
    public static final String END = "/";
    public static final String SUFFIX = "\u0000";

    public static ByteBuf encode(BaseDouyuCmdMsg msg, List<String> containProperties) {
        ByteBuf out = ByteBufAllocator.DEFAULT.buffer(8);
        String bodyDouyuSttString = StrUtil.nullToEmpty((CharSequence)DouyuCodecUtil.toDouyuSttString(msg, containProperties)) + SUFFIX;
        byte[] bodyBytes = bodyDouyuSttString.getBytes(StandardCharsets.UTF_8);
        int length = bodyBytes.length + 8;
        out.writeIntLE(length);
        out.writeIntLE(length);
        out.writeShortLE(689);
        out.writeByte(0);
        out.writeByte(0);
        out.writeBytes(bodyBytes);
        return out;
    }

    public static ByteBuf encode(BaseDouyuCmdMsg msg) {
        return DouyuCodecUtil.encode(msg, null);
    }

    public static List<IDouyuMsg> decode(ByteBuf in) {
        ArrayList<IDouyuMsg> msgList = new ArrayList<IDouyuMsg>();
        LinkedList<ByteBuf> pendingByteBuf = new LinkedList<ByteBuf>();
        do {
            Optional<IDouyuMsg> msg = DouyuCodecUtil.doDecode(in, pendingByteBuf);
            msg.ifPresent(msgList::add);
        } while ((in = (ByteBuf)pendingByteBuf.poll()) != null);
        return msgList;
    }

    private static Optional<IDouyuMsg> doDecode(ByteBuf in, Queue<ByteBuf> pendingByteBuf) {
        int length = in.readIntLE();
        in.readIntLE();
        short msgType = in.readShortLE();
        if (msgType != 690) {
            log.error("decode\u6d88\u606f\u7c7b\u578b \u975e \u6536\u5230\u7684\u6d88\u606f");
        }
        in.readByte();
        in.readByte();
        int contentLength = length - 8;
        byte[] inputBytes = new byte[contentLength];
        in.readBytes(inputBytes);
        if (in.readableBytes() != 0) {
            pendingByteBuf.offer(in);
        }
        String bodyDouyuSttString = new String(inputBytes, 0, inputBytes.length - 1, StandardCharsets.UTF_8);
        return Optional.ofNullable(DouyuCodecUtil.parseDouyuSttString(bodyDouyuSttString, msgType));
    }

    public static String escape(String string) {
        return string == null ? "" : string.replaceAll("@", "@A").replaceAll(END, "@S");
    }

    public static String unescape(String string) {
        return string == null ? "" : string.replaceAll("@S", END).replaceAll("@A", "@");
    }

    public static String toDouyuSttString(Object object, List<String> containProperties) {
        StringBuffer sb = new StringBuffer();
        if (object instanceof IDouyuMsg) {
            Field[] fields;
            Class<?> objectClass = object.getClass();
            for (Field field2 : fields = ReflectUtil.getFields(objectClass, field -> {
                String name = field.getName();
                if (CollUtil.isNotEmpty((Collection)containProperties)) {
                    return containProperties.contains(name);
                }
                return !name.startsWith(SHOULD_IGNORE_PROPERTIES_PREFIX) && !ArrayUtil.contains((Object[])IGNORE_PROPERTIES, (Object)name);
            })) {
                String key = field2.getName();
                Method method = OrLiveChatReflectUtil.getGetterMethod(objectClass, (String)key);
                Object value = ReflectUtil.invoke((Object)object, (Method)method, (Object[])new Object[0]);
                String douyuSttString = DouyuCodecUtil.toDouyuSttString(value, containProperties);
                String escape = DouyuCodecUtil.escape(douyuSttString);
                sb.append(DouyuCodecUtil.escape(key)).append(SPLITTER).append(escape).append(END);
            }
        } else if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            StringBuffer iterableStringBuffer = new StringBuffer();
            for (Object o : iterable) {
                String douyuSttString = DouyuCodecUtil.toDouyuSttString(o, containProperties);
                String escape = DouyuCodecUtil.escape(douyuSttString);
                iterableStringBuffer.append(escape).append(END);
            }
            sb.append(iterableStringBuffer.toString());
        } else if (object instanceof Map) {
            Map map = (Map)object;
            StringBuffer mapStringBuffer = new StringBuffer();
            map.forEach((mapKey, mapValue) -> mapStringBuffer.append(DouyuCodecUtil.escape(StrUtil.toStringOrNull((Object)mapKey))).append(SPLITTER).append(DouyuCodecUtil.escape(DouyuCodecUtil.toDouyuSttString(mapValue, containProperties))).append(END));
            sb.append(mapStringBuffer.toString());
        } else {
            sb.append(StrUtil.nullToEmpty((CharSequence)StrUtil.toStringOrNull((Object)object)));
        }
        return sb.toString();
    }

    public static String toDouyuSttString(Object object) {
        return DouyuCodecUtil.toDouyuSttString(object, null);
    }

    public static IDouyuMsg parseDouyuSttString(String string, short msgType) {
        Map<String, Object> stringObjectMap = DouyuCodecUtil.parseDouyuSttStringToMap(string);
        String type = (String)stringObjectMap.get("type");
        DouyuCmdEnum cmdEnum = DouyuCmdEnum.getByString(type);
        Class msgClass = DouyuCodecUtil.getDouyuMsgClassByType(cmdEnum, msgType);
        if (msgClass == null) {
            if (log.isWarnEnabled()) {
                log.warn("\u6682\u4e0d\u652f\u6301 cmdEnum {}, msgType {}", (Object)cmdEnum, (Object)msgType);
            }
            return null;
        }
        IDouyuMsg t = (IDouyuMsg)ReflectUtil.newInstance(msgClass, (Object[])new Object[0]);
        stringObjectMap.forEach((key, value) -> {
            Field field = ReflectUtil.getField(t.getClass(), (String)key);
            if (field == null) {
                ((BaseDouyuCmdMsg)t).setOther((String)key, OrJacksonUtil.getInstance().valueToTree(value));
            } else {
                ReflectUtil.setFieldValue((Object)t, (Field)field, (Object)value);
            }
        });
        if (t instanceof DgbMsg) {
            DgbMsg msg = (DgbMsg)t;
            String pid = msg.getPid();
            if (StrUtil.isNotBlank((CharSequence)pid)) {
                GiftPropSingle giftSingle = (GiftPropSingle)DouyuApis.giftMap.get((Object)pid, (Func0 & Serializable)() -> {
                    GiftPropSingle gift = GiftPropSingle.DEFAULT_GIFT;
                    try {
                        gift = DouyuApis.getGiftPropSingleByPid(pid);
                    }
                    catch (Exception e) {
                        log.error("\u793c\u7269\u4fe1\u606f\u83b7\u53d6\u5931\u8d25, pid=" + pid, (Throwable)e);
                    }
                    return gift;
                });
                msg.setGiftInfo(giftSingle);
            } else {
                String realRoomId = msg.getRid();
                Map stringGiftListInfoMap = (Map)DouyuApis.roomGiftMap.get((Object)realRoomId, (Func0 & Serializable)() -> DouyuApis.updateRoomGiftMapCache(NumberUtil.parseLong((String)realRoomId)));
                msg.setRoomGiftInfo(stringGiftListInfoMap.getOrDefault(msg.getGfid(), GiftListInfo.DEFAULT_GIFT));
            }
        }
        return t;
    }

    public static Object parseDouyuSttStringToObject(String value) {
        ArrayList<Object> valueObject;
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        if (value.contains(SPLITTER) && value.contains(END)) {
            valueObject = DouyuCodecUtil.parseDouyuSttStringToMap(value);
        } else if (!value.contains(SPLITTER) && value.contains(END)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (String s : value.split(END)) {
                list.add(DouyuCodecUtil.parseDouyuSttStringToObject(DouyuCodecUtil.unescape(s)));
            }
            valueObject = list;
        } else {
            valueObject = value;
        }
        return valueObject;
    }

    public static Map<String, Object> parseDouyuSttStringToMap(String string) {
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        for (String s : string.split(END)) {
            String[] entry = s.split(SPLITTER);
            String key = DouyuCodecUtil.unescape(entry[0]);
            String value = DouyuCodecUtil.unescape((String)ArrayUtil.get((Object)entry, (int)1));
            Object valueObject = DouyuCodecUtil.parseDouyuSttStringToObject(value);
            stringObjectMap.put(key, valueObject);
        }
        return stringObjectMap;
    }

    public static <T extends IDouyuMsg> Class<T> getDouyuMsgClassByType(DouyuCmdEnum douyuCmdEnum, short msgType) {
        if (douyuCmdEnum == null) {
            return DouyuCmdMsg.class;
        }
        Class<?> tClass = douyuCmdEnum.getTClass();
        Class<Object> msgClass = tClass == null ? (douyuCmdEnum == DouyuCmdEnum.mrkl ? (msgType == 690 ? HeartbeatReplyMsg.class : (msgType == 689 ? HeartbeatMsg.class : null)) : DouyuCmdMsg.class) : tClass;
        return msgClass;
    }
}

