/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.huya.msg.base;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsOutputStream;
import com.qq.tars.protocol.tars.support.TarsMethodInfo;
import com.qq.tars.rpc.protocol.tars.TarsServantRequest;
import com.qq.tars.rpc.protocol.tup.UniAttribute;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.HashMap;
import java.util.Map;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.base.BaseHuyaMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.util.HuyaCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrJacksonUtil;

public abstract class BaseWup
extends BaseHuyaMsg {
    private TarsServantRequest tarsServantRequest = new TarsServantRequest(null){
        {
            this.setMethodInfo(new TarsMethodInfo());
        }
    };
    private UniAttribute uniAttribute = new UniAttribute();

    public BaseWup(TarsInputStream is) {
        this.readFrom(is);
    }

    public void writeTo(TarsOutputStream os) {
        os.write((short)3, 1);
        os.write(this.tarsServantRequest.getPacketType(), 2);
        os.write(this.tarsServantRequest.getMessageType(), 3);
        os.write(this.tarsServantRequest.getRequestId(), 4);
        os.write(this.tarsServantRequest.getServantName(), 5);
        os.write(this.tarsServantRequest.getFunctionName(), 6);
        os.write(this.uniAttribute.encode(), 7);
        os.write(this.tarsServantRequest.getTimeout(), 8);
        os.write(this.tarsServantRequest.getContext(), 9);
        os.write(this.tarsServantRequest.getStatus(), 10);
    }

    public void readFrom(TarsInputStream is) {
        this.tarsServantRequest.setVersion(is.read(this.tarsServantRequest.getVersion(), 1, false));
        this.tarsServantRequest.setPacketType(is.read(this.tarsServantRequest.getPacketType(), 2, false));
        this.tarsServantRequest.setMessageType(is.read(this.tarsServantRequest.getMessageType(), 3, false));
        this.tarsServantRequest.setRequestId(is.read(this.tarsServantRequest.getRequestId(), 4, false));
        this.tarsServantRequest.setServantName(is.read(this.tarsServantRequest.getServantName(), 5, false));
        this.tarsServantRequest.setFunctionName(is.read(this.tarsServantRequest.getFunctionName(), 6, false));
        this.uniAttribute.decode(is.read(new byte[0], 7, false));
        this.tarsServantRequest.setTimeout(is.read(this.tarsServantRequest.getTimeout(), 8, false));
        this.tarsServantRequest.setContext((Map)is.readMap(this.tarsServantRequest.getContext(), 9, false));
        this.tarsServantRequest.setStatus((Map)is.readMap(this.tarsServantRequest.getStatus(), 10, false));
    }

    public byte[] encode() {
        TarsOutputStream wupTarsOutputStream = new TarsOutputStream();
        this.writeTo(wupTarsOutputStream);
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
        buffer.writeInt(4 + wupTarsOutputStream.getByteBuffer().position());
        buffer.writeBytes(wupTarsOutputStream.toByteArray());
        return ByteBufUtil.getBytes((ByteBuf)buffer);
    }

    public void decode(byte[] bytes) {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer().writeBytes(bytes);
        int size = byteBuf.readInt();
        if (size < 4) {
            return;
        }
        bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        this.readFrom(HuyaCodecUtil.newUtf8TarsInputStream(bytes));
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.tarsServantRequest.getVersion());
        map.put("packetType", this.tarsServantRequest.getPacketType());
        map.put("messageType", this.tarsServantRequest.getMessageType());
        map.put("requestId", this.tarsServantRequest.getRequestId());
        map.put("servantName", this.tarsServantRequest.getServantName());
        map.put("functionName", this.tarsServantRequest.getFunctionName());
        map.put("timeout", this.tarsServantRequest.getTimeout());
        map.put("context", this.tarsServantRequest.getContext());
        map.put("status", this.tarsServantRequest.getStatus());
        try {
            return OrJacksonUtil.getInstance().writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public TarsServantRequest getTarsServantRequest() {
        return this.tarsServantRequest;
    }

    public UniAttribute getUniAttribute() {
        return this.uniAttribute;
    }

    public void setTarsServantRequest(TarsServantRequest tarsServantRequest) {
        this.tarsServantRequest = tarsServantRequest;
    }

    public void setUniAttribute(UniAttribute uniAttribute) {
        this.uniAttribute = uniAttribute;
    }

    public BaseWup(TarsServantRequest tarsServantRequest, UniAttribute uniAttribute) {
        this.tarsServantRequest = tarsServantRequest;
        this.uniAttribute = uniAttribute;
    }

    public BaseWup() {
    }
}

