/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.huya.msg.factory;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import tech.ordinaryroad.live.chat.client.codec.huya.api.HuyaApis;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaClientTemplateTypeEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaLiveSource;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaOperationEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaWupFunctionEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WebSocketCommand;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.GetLivingInfoReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.GetPropsListReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.LiveLaunchReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.SendMessageReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.UserHeartBeatReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.WSRegisterGroupReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.WSUpdateUserInfoReq;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.WupReq;
import tech.ordinaryroad.live.chat.client.codec.huya.util.HuyaCodecUtil;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;
import tech.ordinaryroad.live.chat.client.commons.util.OrLiveChatCookieUtil;

public class HuyaMsgFactory {
    private static final TimedCache<Object, HuyaMsgFactory> FACTORY_CACHE = new TimedCache(TimeUnit.DAYS.toMillis(1L), new ConcurrentHashMap());
    public static final String KEY_COOKIE_GUID = "guid";
    public static final String KEY_COOKIE_YYUID = "yyuid";
    private final Object roomId;
    private final JsonNode roomInfo;
    private static volatile byte[] heartbeatMsg;
    private static volatile byte[] giftListReqMsg;

    public HuyaMsgFactory(Object roomId) {
        this.roomId = roomId;
        this.roomInfo = HuyaApis.roomInit(roomId);
    }

    public static HuyaMsgFactory getInstance(Object roomId) {
        if (!FACTORY_CACHE.containsKey(roomId)) {
            FACTORY_CACHE.put(roomId, (Object)new HuyaMsgFactory(roomId));
        }
        return (HuyaMsgFactory)FACTORY_CACHE.get(roomId);
    }

    public WebSocketCommand createSendMessageReq(String msg, String ver, String cookie) {
        String yyuid = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_YYUID, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570yyuid");
        });
        String guid = OrLiveChatCookieUtil.getCookieByName((String)cookie, (String)KEY_COOKIE_GUID, () -> {
            throw new BaseException("cookie\u4e2d\u7f3a\u5c11\u53c2\u6570guid");
        });
        SendMessageReq sendMessageReq = new SendMessageReq();
        sendMessageReq.getTUserId().setLUid(NumberUtil.parseLong((String)yyuid));
        sendMessageReq.getTUserId().setSGuid(guid);
        sendMessageReq.getTUserId().setSHuYaUA("webh5&" + ver + "&websocket");
        sendMessageReq.getTUserId().setSCookie(cookie);
        sendMessageReq.getTUserId().setSDeviceInfo("chrome");
        sendMessageReq.setSContent(msg);
        sendMessageReq.setLPid(this.roomInfo.get("lChannelId").asLong());
        WupReq wupReq = new WupReq();
        wupReq.getTarsServantRequest().setServantName("liveui");
        wupReq.getTarsServantRequest().setFunctionName("sendMessage");
        wupReq.getUniAttribute().put("tReq", (Object)sendMessageReq);
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmd_WupReq.getCode());
        webSocketCommand.setVData(wupReq.encode());
        return webSocketCommand;
    }

    public WebSocketCommand createAuth(String ver, String cookie) {
        return this.createLiveLaunchReq(ver, cookie);
    }

    public WebSocketCommand createGetLivingInfoReq(String ver, String cookie) {
        GetLivingInfoReq getLivingInfoReq = new GetLivingInfoReq();
        getLivingInfoReq.getTId().setSHuYaUA("webh5&" + ver + "&websocket");
        getLivingInfoReq.getTId().setSDeviceInfo("chrome");
        getLivingInfoReq.getTId().setSCookie(StrUtil.nullToEmpty((CharSequence)cookie));
        getLivingInfoReq.setLPresenterUid(this.roomInfo.get("lChannelId").asLong());
        WupReq wupReq = new WupReq();
        wupReq.getTarsServantRequest().setServantName("huyaliveui");
        wupReq.getTarsServantRequest().setFunctionName("getLivingInfo");
        wupReq.getUniAttribute().put("tReq", (Object)getLivingInfoReq);
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmd_WupReq.getCode());
        webSocketCommand.setVData(wupReq.encode());
        return webSocketCommand;
    }

    public WebSocketCommand createLiveLaunchReq(String ver, String cookie) {
        LiveLaunchReq liveLaunchReq = new LiveLaunchReq();
        liveLaunchReq.setBSupportDomain(true);
        liveLaunchReq.getTId().setSHuYaUA("webh5&" + ver + "&websocket");
        liveLaunchReq.getTId().setSDeviceInfo("chrome");
        liveLaunchReq.getTId().setSCookie(StrUtil.nullToEmpty((CharSequence)cookie));
        liveLaunchReq.getTLiveUB().setESource(HuyaLiveSource.WEB_HUYA.getCode());
        WupReq wupReq = new WupReq();
        wupReq.getTarsServantRequest().setServantName("liveui");
        wupReq.getTarsServantRequest().setFunctionName("doLaunch");
        wupReq.getUniAttribute().put("tReq", (Object)liveLaunchReq);
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmd_WupReq.getCode());
        webSocketCommand.setVData(wupReq.encode());
        return webSocketCommand;
    }

    public WebSocketCommand createRegisterGroupReq() {
        String lYyid = this.roomInfo.get("lChannelId").asText();
        WSRegisterGroupReq wsRegisterGroupReq = new WSRegisterGroupReq();
        wsRegisterGroupReq.setVGroupId(CollUtil.newArrayList((Object[])new String[]{"live:" + lYyid, "chat:" + lYyid}));
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmdC2S_RegisterGroupReq.getCode());
        webSocketCommand.setVData(wsRegisterGroupReq.toByteArray());
        return webSocketCommand;
    }

    public WebSocketCommand createUpdateUserInfoReq() {
        WSUpdateUserInfoReq wsUpdateUserInfoReq = new WSUpdateUserInfoReq();
        wsUpdateUserInfoReq.setSAppSrc("HUYA&ZH&2052");
        wsUpdateUserInfoReq.getTWSMsgStatInfo().setISupportAckMsgStat(1);
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmdC2S_UpdateUserInfoReq.getCode());
        webSocketCommand.setVData(wsUpdateUserInfoReq.toByteArray());
        return webSocketCommand;
    }

    public WebSocketCommand createGiftListReq(String ver) {
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmd_WupReq.getCode());
        webSocketCommand.setVData(this.getGiftListReqMsg(ver));
        return webSocketCommand;
    }

    public WebSocketCommand createHeartbeat(String ver, String cookie) {
        WebSocketCommand webSocketCommand = new WebSocketCommand();
        webSocketCommand.setOperation(HuyaOperationEnum.EWSCmdC2S_HeartBeatReq.getCode());
        webSocketCommand.setVData(this.getHeartbeatMsg(ver, cookie));
        return webSocketCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHeartbeatMsg(String ver, String cookie) {
        if (heartbeatMsg == null) {
            HuyaMsgFactory huyaMsgFactory = this;
            synchronized (huyaMsgFactory) {
                if (heartbeatMsg == null) {
                    UserHeartBeatReq userHeartBeatReq = new UserHeartBeatReq();
                    userHeartBeatReq.getTId().setSHuYaUA("webh5&" + ver + "&websocket");
                    userHeartBeatReq.getTId().setSDeviceInfo("chrome");
                    userHeartBeatReq.getTId().setSCookie(StrUtil.nullToEmpty((CharSequence)cookie));
                    userHeartBeatReq.setLPid(this.roomInfo.get("lChannelId").asLong());
                    userHeartBeatReq.setELineType(-1);
                    heartbeatMsg = HuyaCodecUtil.encode("onlineui", HuyaWupFunctionEnum.OnUserHeartBeat, userHeartBeatReq);
                }
            }
        }
        return heartbeatMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGiftListReqMsg(String ver) {
        if (giftListReqMsg == null) {
            HuyaMsgFactory huyaMsgFactory = this;
            synchronized (huyaMsgFactory) {
                if (giftListReqMsg == null) {
                    GetPropsListReq getPropsListReq = new GetPropsListReq();
                    getPropsListReq.getTUserId().setLUid(this.roomInfo.get("lYyid").asLong());
                    getPropsListReq.getTUserId().setSHuYaUA("webh5&" + ver + "&websocket");
                    getPropsListReq.setITemplateType(HuyaClientTemplateTypeEnum.TPL_MIRROR.getCode());
                    giftListReqMsg = HuyaCodecUtil.encode("PropsUIServer", HuyaWupFunctionEnum.getPropsList, getPropsListReq);
                }
            }
        }
        return giftListReqMsg;
    }
}

