/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.codec.huya.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ByteUtil;
import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsStructBase;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaDecorationAppTypeEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaDecorationViewTypeEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaOperationEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.constant.HuyaWupFunctionEnum;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.VerifyCookieRsp;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WSPushMessage;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WSPushMessage_V2;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WSRegisterGroupRsp;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WSRegisterRsp;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WebSocketCommand;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.WupRsp;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.base.IHuyaMsg;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.BadgeInfo;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.dto.DecorationInfo;
import tech.ordinaryroad.live.chat.client.codec.huya.msg.req.WupReq;
import tech.ordinaryroad.live.chat.client.commons.base.exception.BaseException;

public class HuyaCodecUtil {
    private static final Logger log = LoggerFactory.getLogger(HuyaCodecUtil.class);

    public static List<IHuyaMsg> decode(ByteBuf in) {
        ArrayList<IHuyaMsg> msgList = new ArrayList<IHuyaMsg>();
        LinkedList<ByteBuf> pendingByteBuf = new LinkedList<ByteBuf>();
        do {
            msgList.addAll(HuyaCodecUtil.doDecode(in, pendingByteBuf));
        } while ((in = (ByteBuf)pendingByteBuf.poll()) != null);
        return msgList;
    }

    private static List<? extends IHuyaMsg> doDecode(ByteBuf in, Queue<ByteBuf> pendingByteBuf) {
        byte[] bytes = new byte[in.readableBytes()];
        in.readBytes(bytes);
        WebSocketCommand webSocketCommand = new WebSocketCommand(HuyaCodecUtil.newUtf8TarsInputStream(bytes));
        HuyaOperationEnum operationEnum = webSocketCommand.getOperationEnum();
        if (operationEnum == null) {
            throw new BaseException(String.format("\u672a\u77e5operation: %d", webSocketCommand.getOperation()));
        }
        switch (operationEnum) {
            case EWSCmd_RegisterRsp: {
                return Collections.singletonList(new WSRegisterRsp(HuyaCodecUtil.newUtf8TarsInputStream(webSocketCommand.getVData())));
            }
            case EWSCmdS2C_RegisterGroupRsp: {
                return Collections.singletonList(new WSRegisterGroupRsp(HuyaCodecUtil.newUtf8TarsInputStream(webSocketCommand.getVData())));
            }
            case EWSCmd_WupRsp: {
                return Collections.singletonList(new WupRsp(webSocketCommand.getVData()));
            }
            case EWSCmdS2C_MsgPushReq: {
                return Collections.singletonList(new WSPushMessage(HuyaCodecUtil.newUtf8TarsInputStream(webSocketCommand.getVData())));
            }
            case EWSCmdS2C_VerifyCookieRsp: {
                return Collections.singletonList(new VerifyCookieRsp(HuyaCodecUtil.newUtf8TarsInputStream(webSocketCommand.getVData())));
            }
            case EWSCmdS2C_MsgPushReq_V2: {
                WSPushMessage_V2 pushMessageV2 = new WSPushMessage_V2(HuyaCodecUtil.newUtf8TarsInputStream(webSocketCommand.getVData()));
                return pushMessageV2.getVMsgItem();
            }
        }
        return Collections.singletonList(webSocketCommand);
    }

    public static byte[] encode(String servantName, HuyaWupFunctionEnum function, TarsStructBase req) {
        WupReq wupReq = new WupReq();
        wupReq.getTarsServantRequest().setServantName(servantName);
        wupReq.getTarsServantRequest().setFunctionName(function.name());
        wupReq.getUniAttribute().put("tReq", (Object)req);
        return wupReq.encode();
    }

    public static TarsInputStream newUtf8TarsInputStream(byte[] bytes) {
        TarsInputStream tarsInputStream = new TarsInputStream(bytes);
        tarsInputStream.setServerEncoding(StandardCharsets.UTF_8.name());
        return tarsInputStream;
    }

    public static Optional<? extends TarsStructBase> decodeDecorationInfo(DecorationInfo decorationInfo) {
        int iViewType = decorationInfo.getIViewType();
        HuyaDecorationViewTypeEnum huyaDecorationViewTypeEnum = HuyaDecorationViewTypeEnum.getByCode(iViewType);
        if (huyaDecorationViewTypeEnum == null) {
            return Optional.empty();
        }
        switch (huyaDecorationViewTypeEnum) {
            case kDecorationViewTypeCustomized: {
                int iAppId = decorationInfo.getIAppId();
                HuyaDecorationAppTypeEnum huyaDecorationAppTypeEnum = HuyaDecorationAppTypeEnum.getByCode(iAppId);
                if (huyaDecorationAppTypeEnum == null) {
                    return Optional.empty();
                }
                switch (huyaDecorationAppTypeEnum) {
                    case kDecorationAppTypeFans: {
                        BadgeInfo badgeInfo = new BadgeInfo();
                        badgeInfo.readFrom(HuyaCodecUtil.newUtf8TarsInputStream(decorationInfo.getVData()));
                        return Optional.of(badgeInfo);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static String ab2str(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedInt = ByteUtil.byteToUnsignedInt((byte)bytes[i]);
            chars[i] = (char)unsignedInt;
        }
        return ArrayUtil.join((Object)chars, (CharSequence)"");
    }

    public static String btoa(String string) {
        return Base64.encode((CharSequence)string);
    }
}

