/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.commons.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OrLiveChatCookieUtil {
    public static String toString(List<HttpCookie> cookies) {
        if (CollUtil.isEmpty(cookies)) {
            return "";
        }
        return cookies.stream().map(httpCookie -> {
            httpCookie.setVersion(0);
            return httpCookie.toString();
        }).collect(Collectors.joining("; "));
    }

    public static Map<String, String> parseCookieString(String cookies) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StrUtil.isNotBlank((CharSequence)cookies) && !StrUtil.isNullOrUndefined((CharSequence)cookies)) {
            try {
                String[] split;
                for (String s : split = cookies.split("; ")) {
                    String key = StrUtil.subBefore((CharSequence)s, (char)'=', (boolean)false);
                    String value = StrUtil.subAfter((CharSequence)s, (char)'=', (boolean)false);
                    map.put(key, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("cookie\u89e3\u6790\u5931\u8d25 " + cookies, e);
            }
        }
        return map;
    }

    public static String toCookieString(Map<String, String> cookies) {
        if (cookies.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> stringStringEntry : cookies.entrySet()) {
            String key = stringStringEntry.getKey();
            String value = stringStringEntry.getValue();
            sb.append(key).append("=").append(value).append("; ");
        }
        int length = sb.length();
        sb.delete(length - 2, length);
        return sb.toString();
    }

    public static String getCookieByName(Map<String, String> cookieMap, String name, Supplier<String> supplier) {
        String str = MapUtil.getStr(cookieMap, (Object)name);
        return str == null ? supplier.get() : str;
    }

    public static String getCookieByName(String cookie, String name, Supplier<String> supplier) {
        String str = MapUtil.getStr(OrLiveChatCookieUtil.parseCookieString(cookie), (Object)name);
        return str == null ? supplier.get() : str;
    }
}

