/*
 * Decompiled with CFR 0.152.
 */
package tech.ordinaryroad.live.chat.client.commons.util;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.util.function.Function;

public class OrLiveChatUrlUtil
extends URLUtil {
    private static final String PATTERN_URI_SCHEME = "([a-zA-Z]+):\\/\\/";
    private static final String PATTERN_URI_PORT = "[a-zA-Z]+:\\/\\/.+:([0-9]+)";

    public static String getScheme(String location) {
        return ReUtil.getGroup1((String)PATTERN_URI_SCHEME, (CharSequence)location);
    }

    public static int getPort(String location, Function<String, Integer> defaultPortSupplier) {
        location = StrUtil.subBefore((CharSequence)location, (CharSequence)"?", (boolean)false);
        int port = -1;
        int i = NumberUtil.parseInt((String)ReUtil.getGroup1((String)PATTERN_URI_PORT, (CharSequence)location));
        if (i > 0) {
            port = i;
        } else if (defaultPortSupplier != null) {
            port = defaultPortSupplier.apply(location);
        }
        return port;
    }

    public static int getPort(String location) {
        return OrLiveChatUrlUtil.getPort(location, null);
    }

    public static int getWebSocketUriPort(String location) {
        return OrLiveChatUrlUtil.getPort(location, string -> {
            String scheme = OrLiveChatUrlUtil.getScheme(location);
            if ("wss".equalsIgnoreCase(scheme)) {
                return 443;
            }
            if ("ws".equalsIgnoreCase(scheme)) {
                return 80;
            }
            return -1;
        });
    }
}

