/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.extension.defaultimpl.alarm.impl;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiUserGetByMobileRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserGetByMobileResponse;
import com.taobao.api.TaobaoRequest;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import tech.powerjob.common.exception.PowerJobException;

public class DingTalkUtils
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DingTalkUtils.class);
    private String accessToken;
    private final DingTalkClient sendMsgClient = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2");
    private final DingTalkClient accessTokenClient = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
    private final DingTalkClient userIdClient = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/get_by_mobile");
    private final ScheduledExecutorService scheduledPool;
    private static final long FLUSH_ACCESS_TOKEN_RATE = 6000L;
    private static final String GET_TOKEN_URL = "https://oapi.dingtalk.com/gettoken";
    private static final String SEND_URL = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    private static final String GET_USER_ID_URL = "https://oapi.dingtalk.com/user/get_by_mobile";

    public DingTalkUtils(String appKey, String appSecret) {
        this.refreshAccessToken(appKey, appSecret);
        if (StringUtils.isEmpty((CharSequence)this.accessToken)) {
            throw new PowerJobException("fetch AccessToken failed, please check your appKey & appSecret");
        }
        this.scheduledPool = Executors.newSingleThreadScheduledExecutor();
        this.scheduledPool.scheduleAtFixedRate(() -> this.refreshAccessToken(appKey, appSecret), 6000L, 6000L, TimeUnit.SECONDS);
    }

    private void refreshAccessToken(String appKey, String appSecret) {
        try {
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(appKey);
            req.setAppsecret(appSecret);
            req.setHttpMethod(HttpMethod.GET.name());
            OapiGettokenResponse rsp = (OapiGettokenResponse)this.accessTokenClient.execute((TaobaoRequest)req);
            if (rsp.isSuccess()) {
                this.accessToken = rsp.getAccessToken();
            } else {
                log.warn("[DingTalkUtils] flush accessToken failed with req({}),code={},msg={}.", new Object[]{req.getTextParams(), rsp.getErrcode(), rsp.getErrmsg()});
            }
        }
        catch (Exception e) {
            log.warn("[DingTalkUtils] flush accessToken failed.", (Throwable)e);
        }
    }

    public String fetchUserIdByMobile(String mobile) throws Exception {
        OapiUserGetByMobileRequest request = new OapiUserGetByMobileRequest();
        request.setMobile(mobile);
        OapiUserGetByMobileResponse execute = (OapiUserGetByMobileResponse)this.userIdClient.execute((TaobaoRequest)request, this.accessToken);
        if (execute.isSuccess()) {
            return execute.getUserid();
        }
        log.info("[DingTalkUtils] fetch userId by mobile({}) failed,reason is {}.", (Object)mobile, (Object)execute.getErrmsg());
        throw new PowerJobException("fetch userId by phone number failed, reason is " + execute.getErrmsg());
    }

    public void sendMarkdownAsync(String title, List<MarkdownEntity> entities, String userList, Long agentId) throws Exception {
        OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
        request.setUseridList(userList);
        request.setAgentId(agentId);
        request.setToAllUser(Boolean.valueOf(false));
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        StringBuilder mdBuilder = new StringBuilder();
        mdBuilder.append("## ").append(title).append("\n");
        for (MarkdownEntity entity : entities) {
            mdBuilder.append("#### ").append(entity.title).append("\n");
            mdBuilder.append("> ").append(entity.detail).append("\n\n");
        }
        msg.setMsgtype("markdown");
        msg.setMarkdown(new OapiMessageCorpconversationAsyncsendV2Request.Markdown());
        msg.getMarkdown().setTitle(title);
        msg.getMarkdown().setText(mdBuilder.toString());
        request.setMsg(msg);
        this.sendMsgClient.execute((TaobaoRequest)request, this.accessToken);
    }

    @Override
    public void close() throws IOException {
        this.scheduledPool.shutdownNow();
    }

    public static final class MarkdownEntity {
        private final String title;
        private final String detail;

        public MarkdownEntity(String title, String detail) {
            this.title = title;
            this.detail = detail;
        }
    }
}

