/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.extension.defaultimpl.alarm.impl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.powerjob.server.extension.Alarmable;
import tech.powerjob.server.extension.defaultimpl.alarm.module.Alarm;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;

@Service
public class MailAlarmService
implements Alarmable {
    private static final Logger log = LoggerFactory.getLogger(MailAlarmService.class);
    @Resource
    private Environment environment;
    private JavaMailSender javaMailSender;
    @Value(value="${spring.mail.username:''}")
    private String from;

    @Override
    public void onFailed(Alarm alarm, List<UserInfoDO> targetUserList) {
        if (CollectionUtils.isEmpty(targetUserList) || this.javaMailSender == null || StringUtils.isEmpty((CharSequence)this.from)) {
            return;
        }
        SimpleMailMessage sm = new SimpleMailMessage();
        try {
            sm.setFrom(this.from);
            sm.setTo((String[])targetUserList.stream().map(UserInfoDO::getEmail).filter(Objects::nonNull).toArray(String[]::new));
            sm.setSubject(alarm.fetchTitle());
            sm.setText(alarm.fetchContent());
            this.javaMailSender.send(sm);
        }
        catch (Exception e) {
            log.warn("[MailAlarmService] send mail failed, reason is {}", (Object)e.getMessage());
        }
    }

    @Autowired(required=false)
    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }
}

