/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.spring.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public abstract class SpringBootBindUtil {
    public static final IBind BIND;

    public static <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
        return BIND.bind(environment, targetClass, prefix);
    }

    static {
        IBind bind;
        try {
            Class.forName("org.springframework.boot.context.properties.bind.Binder");
            bind = new SpringBoot2Bind();
        }
        catch (Exception e) {
            bind = new SpringBoot1Bind();
        }
        BIND = bind;
    }

    public static class SpringBoot2Bind
    implements IBind {
        @Override
        public <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
            try {
                Class<?> bindClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
                Method getMethod = bindClass.getDeclaredMethod("get", Environment.class);
                Method bindMethod = bindClass.getDeclaredMethod("bind", String.class, Class.class);
                Object bind = getMethod.invoke(null, environment);
                Object bindResult = bindMethod.invoke(bind, prefix, targetClass);
                Method resultGetMethod = bindResult.getClass().getDeclaredMethod("get", new Class[0]);
                return (T)resultGetMethod.invoke(bindResult, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class SpringBoot1Bind
    implements IBind {
        @Override
        public <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
            try {
                Class<?> resolverClass = Class.forName("org.springframework.boot.bind.RelaxedPropertyResolver");
                Constructor<?> resolverConstructor = resolverClass.getDeclaredConstructor(PropertyResolver.class);
                Method getSubPropertiesMethod = resolverClass.getDeclaredMethod("getSubProperties", String.class);
                Object resolver = resolverConstructor.newInstance(environment);
                Map properties = (Map)getSubPropertiesMethod.invoke(resolver, "");
                T target = targetClass.newInstance();
                Class<?> binderClass = Class.forName("org.springframework.boot.bind.RelaxedDataBinder");
                Constructor<?> binderConstructor = binderClass.getDeclaredConstructor(Object.class, String.class);
                Method bindMethod = binderClass.getMethod("bind", PropertyValues.class);
                Object binder = binderConstructor.newInstance(target, prefix);
                bindMethod.invoke(binder, new MutablePropertyValues(properties));
                return target;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface IBind {
        public <T> T bind(Environment var1, Class<T> var2, String var3);
    }
}

