/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.glc.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import top.gotoeasy.framework.glc.logback.appender.MdcUtil;

public class GlcFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.setMdcKeyValues(request);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected void setMdcKeyValues(ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String traceid = httpServletRequest.getHeader("traceid");
        MdcUtil.setTraceId(traceid == null || traceid.length() == 0 ? MdcUtil.generateTraceId() : traceid);
        MdcUtil.setClientIp(this.getIpAddr(httpServletRequest));
    }

    protected String getIpAddr(HttpServletRequest request) {
        String[] headerNames;
        for (String headerName : headerNames = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"}) {
            String ip = request.getHeader(headerName);
            if (ip == null || ip.length() <= 0 || "unknown".equalsIgnoreCase(ip)) continue;
            int index = ip.indexOf(44);
            if (index > 0) {
                ip = ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }
}

