/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.glc.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import top.gotoeasy.framework.glc.logback.appender.Util;

public class GlcAmqpAppender
extends AppenderBase<ILoggingEvent> {
    private String amqpHost;
    private int amqpPort;
    private String amqpUser;
    private String amqpPassword;
    private String system;
    private Layout<ILoggingEvent> layout;
    private int cnt = 0;
    private boolean enableGlc = true;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    protected Connection connection = null;
    protected Channel channel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initConnectionChannel() throws Exception {
        if (this.channel != null) {
            return;
        }
        Connection conn = null;
        Channel chan = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(this.amqpHost);
            factory.setPort(this.amqpPort);
            factory.setUsername(this.amqpUser);
            factory.setPassword(this.amqpPassword);
            conn = factory.newConnection();
            chan = conn.createChannel();
            chan.queueDeclare("glc-log-queue", false, false, false, null);
        }
        finally {
            this.connection = conn;
            this.channel = chan;
        }
    }

    protected void append(ILoggingEvent event) {
        if (!this.enableGlc) {
            return;
        }
        if (event == null || !this.isStarted()) {
            if (this.cnt++ < 10) {
                System.err.println("\u65e5\u5fd7\u4e8b\u4ef6\u4e3a\u7a7a\u6216\u8be5Appender\u672a\u88ab\u521d\u59cb\u5316");
            }
            return;
        }
        this.executor.execute(() -> this.sendToRabbitMQ(this.layout.doLayout((Object)event), event));
    }

    protected void sendToRabbitMQ(String text, ILoggingEvent event) {
        if (text == null) {
            return;
        }
        try {
            if (this.channel == null) {
                this.initConnectionChannel();
            }
            String traceid = (String)event.getMDCPropertyMap().get("traceid");
            String clientip = (String)event.getMDCPropertyMap().get("clientip");
            String user = (String)event.getMDCPropertyMap().get("user");
            String body = "{\"text\":" + Util.encodeStr(text.trim());
            body = body + ",\"date\":\"" + Util.getDateString() + "\"";
            body = body + ",\"system\":" + Util.encodeStr(this.getSystem());
            body = body + ",\"servername\":" + Util.encodeStr(Util.getServerName());
            body = body + ",\"serverip\":" + Util.encodeStr(Util.getServerIp());
            body = body + ",\"loglevel\":\"" + event.getLevel().toString() + "\"";
            if (traceid != null && !"".equals(traceid)) {
                body = body + ",\"traceid\":" + Util.encodeStr(traceid);
            }
            if (clientip != null && !"".equals(clientip)) {
                body = body + ",\"clientip\":" + Util.encodeStr(clientip);
            }
            if (user != null && !"".equals(user)) {
                body = body + ",\"user\":" + Util.encodeStr(user);
            }
            body = body + "}";
            this.channel.basicPublish("", "glc-log-queue", null, body.getBytes("utf-8"));
        }
        catch (Exception e) {
            if (this.cnt++ < 10) {
                e.printStackTrace();
            }
            this.resetConnectionChannel();
        }
    }

    public void start() {
        String system;
        String password;
        String user;
        String port;
        String host;
        if (this.layout == null) {
            System.err.println("Layout\u672a\u88ab\u521d\u59cb\u5316");
        }
        super.start();
        String enable = System.getenv("GLC_ENABLE");
        if ("false".equalsIgnoreCase(enable) || "0".equals(enable)) {
            this.enableGlc = false;
        }
        if ((host = System.getenv("GLC_AMQP_HOST")) != null && !"".equals(host = host.trim())) {
            this.setAmqpHost(host);
        }
        if ((port = System.getenv("GLC_AMQP_PORT")) != null && !"".equals(port = port.trim())) {
            this.setAmqpPort(Integer.valueOf(port));
        }
        if ((user = System.getenv("GLC_AMQP_USER")) != null && !"".equals(user = user.trim())) {
            this.setAmqpUser(user);
        }
        if ((password = System.getenv("GLC_AMQP_PASSWORD")) != null && !"".equals(password = password.trim())) {
            this.setAmqpPassword(password);
        }
        if ((system = System.getenv("GLC_SYSTEM")) != null && !"".equals(system = system.trim())) {
            this.setSystem(system);
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
    }

    public String getAmqpHost() {
        return this.amqpHost;
    }

    public void setAmqpHost(String amqpHost) {
        this.amqpHost = amqpHost;
    }

    public int getAmqpPort() {
        return this.amqpPort;
    }

    public void setAmqpPort(int amqpPort) {
        this.amqpPort = amqpPort;
    }

    public String getAmqpUser() {
        return this.amqpUser;
    }

    public void setAmqpUser(String amqpUser) {
        this.amqpUser = amqpUser;
    }

    public String getAmqpPassword() {
        return this.amqpPassword;
    }

    public void setAmqpPassword(String amqpPassword) {
        this.amqpPassword = amqpPassword;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getSystem() {
        return this.system == null ? "" : this.system;
    }

    protected synchronized void resetConnectionChannel() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.channel = null;
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.connection = null;
        }
    }
}

