/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.glc.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import top.gotoeasy.framework.glc.logback.appender.Util;

public class GlcHttpJsonAppender
extends AppenderBase<ILoggingEvent> {
    private String glcApiUrl;
    private String glcApiKey;
    private String system = "default";
    private Layout<ILoggingEvent> layout;
    private String headerKey;
    private String headerVal;
    private int cnt = 0;
    private boolean enableGlc = true;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    protected void append(ILoggingEvent event) {
        if (!this.enableGlc) {
            return;
        }
        if (event == null || !this.isStarted()) {
            if (this.cnt++ < 10) {
                System.err.println("\u65e5\u5fd7\u4e8b\u4ef6\u4e3a\u7a7a\u6216\u8be5Appender\u672a\u88ab\u521d\u59cb\u5316");
            }
            return;
        }
        this.executor.execute(() -> this.submitToGlogCenter(this.layout.doLayout((Object)event), event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitToGlogCenter(String text, ILoggingEvent event) {
        if (text == null) {
            return;
        }
        FilterOutputStream dos = null;
        String body = null;
        try {
            String traceid = (String)event.getMDCPropertyMap().get("traceid");
            String clientip = (String)event.getMDCPropertyMap().get("clientip");
            String user = (String)event.getMDCPropertyMap().get("user");
            body = "{\"text\":" + Util.encodeStr(text.trim());
            body = body + ",\"date\":\"" + Util.getDateString() + "\"";
            body = body + ",\"system\":" + Util.encodeStr(this.getSystem());
            body = body + ",\"servername\":" + Util.encodeStr(Util.getServerName());
            body = body + ",\"serverip\":" + Util.encodeStr(Util.getServerIp());
            body = body + ",\"loglevel\":\"" + event.getLevel().toString() + "\"";
            if (traceid != null && !"".equals(traceid)) {
                body = body + ",\"traceid\":" + Util.encodeStr(traceid);
            }
            if (clientip != null && !"".equals(clientip)) {
                body = body + ",\"clientip\":" + Util.encodeStr(clientip);
            }
            if (user != null && !"".equals(user)) {
                body = body + ",\"user\":" + Util.encodeStr(user);
            }
            body = body + "}";
            URL url = new URL(this.glcApiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (this.headerKey != null && !"".equals(this.headerVal)) {
                connection.setRequestProperty(this.headerKey, this.headerVal);
            }
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            dos = new DataOutputStream(connection.getOutputStream());
            dos.write(body.getBytes("utf-8"));
            ((DataOutputStream)dos).flush();
            connection.getContent();
            connection.disconnect();
        }
        catch (Exception e) {
            if (this.cnt++ < 10) {
                System.err.println("[GLC\u65e5\u5fd7\u53d1\u9001\u5f02\u5e38][\u5730\u5740\uff1a" + this.glcApiUrl + "][\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage() + "]");
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void start() {
        String system;
        String apiKey;
        String apiUrl;
        if (this.layout == null) {
            System.err.println("Layout\u672a\u88ab\u521d\u59cb\u5316");
        }
        super.start();
        String enable = System.getenv("GLC_ENABLE");
        if ("false".equalsIgnoreCase(enable) || "0".equals(enable)) {
            this.enableGlc = false;
        }
        if ((apiUrl = System.getenv("GLC_API_URL")) != null && !"".equals(apiUrl = apiUrl.trim())) {
            this.setGlcApiUrl(apiUrl);
        }
        if ((apiKey = System.getenv("GLC_API_KEY")) != null && !"".equals(apiKey = apiKey.trim())) {
            this.setGlcApiKey(apiKey);
        }
        if ((system = System.getenv("GLC_SYSTEM")) != null && !"".equals(system = system.trim())) {
            this.setSystem(system);
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String GetGlcApiUrl() {
        return this.glcApiUrl;
    }

    public void setGlcApiUrl(String glcApiUrl) {
        this.glcApiUrl = glcApiUrl;
    }

    public String GetGlcApiKey() {
        return this.glcApiKey;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getSystem() {
        return this.system == null ? "" : this.system;
    }

    public void setGlcApiKey(String glcApiKey) {
        this.glcApiKey = glcApiKey;
        String key = glcApiKey.split(":")[0];
        String value = glcApiKey.substring(key.length() + 1).trim();
        if (!"".equals(key = key.trim())) {
            this.headerKey = key;
            this.headerVal = value;
        }
    }
}

