/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.glc.logback.appender;

import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;

public class Util {
    private static String serverIp = "";
    private static String serverName = "";
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static Object lockObject = new Object();
    private static final char[] hex = "0123456789ABCDEF".toCharArray();

    private static void initServerIp() {
        Object ip;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    String addr = ((InetAddress)ip).getHostAddress();
                    if ("eth0".equals(netInterface.getName())) {
                        serverIp = addr;
                        return;
                    }
                    list.add(ip);
                }
            }
        }
        catch (Exception allNetInterfaces) {
            // empty catch block
        }
        for (int i = 0; i < list.size(); ++i) {
            ip = ((InetAddress)list.get(i)).getHostAddress();
            if (((String)ip).startsWith("192.")) {
                serverIp = ip;
                continue;
            }
            if (((String)ip).startsWith("17.")) {
                if (serverIp.startsWith("192.")) continue;
                serverIp = ip;
                continue;
            }
            if (((String)ip).startsWith("10.")) {
                if (serverIp.startsWith("192.") || serverIp.startsWith("172.")) continue;
                serverIp = ip;
                continue;
            }
            if (!"".equals(serverIp)) continue;
            serverIp = ip;
        }
    }

    public static String getServerName() {
        if ("".equals(serverName)) {
            try {
                serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return serverName;
    }

    public static String getServerIp() {
        if ("".equals(serverIp)) {
            Util.initServerIp();
        }
        if ("".equals(serverIp)) {
            try {
                serverIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return serverIp;
    }

    public static String getDateString() {
        SimpleDateFormat sdf = Util.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getSimpleDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = threadLocal.get();
        if (simpleDateFormat == null) {
            Object object = lockObject;
            synchronized (object) {
                if (simpleDateFormat == null) {
                    simpleDateFormat = new SimpleDateFormat(format);
                    simpleDateFormat.setLenient(false);
                    threadLocal.set(simpleDateFormat);
                }
            }
        }
        simpleDateFormat.applyPattern(format);
        return simpleDateFormat;
    }

    public static String encodeStr(String str) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        StringCharacterIterator it = new StringCharacterIterator(str);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                buf.append("\\\"");
            } else if (c == '\\') {
                buf.append("\\\\");
            } else if (c == '/') {
                buf.append("\\/");
            } else if (c == '\b') {
                buf.append("\\b");
            } else if (c == '\f') {
                buf.append("\\f");
            } else if (c == '\n') {
                buf.append("\\n");
            } else if (c == '\r') {
                buf.append("\\r");
            } else if (c == '\t') {
                buf.append("\\t");
            } else if (Character.isISOControl(c)) {
                Util.addUnicode(buf, c);
            } else {
                buf.append(c);
            }
            c = it.next();
        }
        buf.append('\"');
        return buf.toString();
    }

    private static void addUnicode(StringBuilder buf, char c) {
        buf.append("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            buf.append(hex[digit]);
            n <<= 4;
        }
    }

    public static String hash(String str) {
        int i;
        int rs = 53653;
        int n = i = str == null ? 0 : str.length();
        while (i > 0) {
            rs = rs * 33 ^ str.charAt(--i);
        }
        return new BigDecimal((long)rs & 0xFFFFFFFFL).toPlainString();
    }
}

