/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.ReplaceSelector;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.Selectors;

public abstract class AbstractSelectable
implements Selectable {
    protected abstract List<String> getSourceTexts();

    @Override
    public Selectable css(String selector) {
        return this.$(selector);
    }

    @Override
    public Selectable css(String selector, String attrName) {
        return this.$(selector, attrName);
    }

    protected Selectable select(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            String result = selector.select(string);
            if (result == null) continue;
            results.add(result);
        }
        return new PlainText(results);
    }

    protected Selectable selectList(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            List<String> result = selector.selectList(string);
            results.addAll(result);
        }
        return new PlainText(results);
    }

    @Override
    public List<String> all() {
        return this.getSourceTexts();
    }

    @Override
    public Selectable jsonPath(String jsonPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String get() {
        if (CollectionUtils.isNotEmpty(this.all())) {
            return this.all().get(0);
        }
        return null;
    }

    @Override
    public Selectable select(Selector selector) {
        return this.select(selector, this.getSourceTexts());
    }

    @Override
    public Selectable selectList(Selector selector) {
        return this.selectList(selector, this.getSourceTexts());
    }

    @Override
    public Selectable regex(String regex) {
        RegexSelector regexSelector = Selectors.regex(regex);
        return this.selectList(regexSelector, this.getSourceTexts());
    }

    @Override
    public Selectable regex(String regex, int group) {
        RegexSelector regexSelector = Selectors.regex(regex, group);
        return this.selectList(regexSelector, this.getSourceTexts());
    }

    @Override
    public Selectable replace(String regex, String replacement) {
        ReplaceSelector replaceSelector = new ReplaceSelector(regex, replacement);
        return this.select(replaceSelector, this.getSourceTexts());
    }

    public String getFirstSourceText() {
        if (this.getSourceTexts() != null && this.getSourceTexts().size() > 0) {
            return this.getSourceTexts().get(0);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.get();
    }

    @Override
    public boolean match() {
        return this.getSourceTexts() != null && this.getSourceTexts().size() > 0;
    }
}

