/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.codecraft.webmagic.selector.Selector;

public class JsonPathSelector
implements Selector {
    private final String jsonPathStr;
    private final JsonPath jsonPath;

    public JsonPathSelector(String jsonPathStr) {
        this.jsonPathStr = jsonPathStr;
        this.jsonPath = JsonPath.compile((String)this.jsonPathStr, (Predicate[])new Predicate[0]);
    }

    public String getJsonPathStr() {
        return this.jsonPathStr;
    }

    @Override
    public String select(String text) {
        List list;
        Object object = this.jsonPath.read(text);
        if (object == null) {
            return null;
        }
        if (object instanceof List && (list = (List)object).size() > 0) {
            return this.toString(list.iterator().next());
        }
        return object.toString();
    }

    private String toString(Object object) {
        if (object instanceof Map) {
            return JSON.toJSONString((Object)object);
        }
        return String.valueOf(object);
    }

    @Override
    public List<String> selectList(String text) {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.jsonPath.read(text);
        if (object == null) {
            return list;
        }
        if (object instanceof List) {
            List items = (List)object;
            for (Object item : items) {
                list.add(this.toString(item));
            }
        } else {
            list.add(this.toString(object));
        }
        return list;
    }
}

