/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.monitor;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.monitor.SpiderMonitor;
import us.codecraft.webmagic.monitor.SpiderStatusMXBean;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;

public class SpiderStatus
implements SpiderStatusMXBean {
    protected final Spider spider;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SpiderMonitor.MonitorSpiderListener monitorSpiderListener;

    public SpiderStatus(Spider spider, SpiderMonitor.MonitorSpiderListener monitorSpiderListener) {
        this.spider = spider;
        this.monitorSpiderListener = monitorSpiderListener;
    }

    @Override
    public String getName() {
        return this.spider.getUUID();
    }

    @Override
    public int getLeftPageCount() {
        if (this.spider.getScheduler() instanceof MonitorableScheduler) {
            return ((MonitorableScheduler)this.spider.getScheduler()).getLeftRequestsCount((Task)this.spider);
        }
        this.logger.warn("Get leftPageCount fail, try to use a Scheduler implement MonitorableScheduler for monitor count!");
        return -1;
    }

    @Override
    public int getTotalPageCount() {
        if (this.spider.getScheduler() instanceof MonitorableScheduler) {
            return ((MonitorableScheduler)this.spider.getScheduler()).getTotalRequestsCount((Task)this.spider);
        }
        this.logger.warn("Get totalPageCount fail, try to use a Scheduler implement MonitorableScheduler for monitor count!");
        return -1;
    }

    @Override
    public int getSuccessPageCount() {
        return this.monitorSpiderListener.getSuccessCount().get();
    }

    @Override
    public int getErrorPageCount() {
        return this.monitorSpiderListener.getErrorCount().get();
    }

    @Override
    public List<String> getErrorPages() {
        return this.monitorSpiderListener.getErrorUrls();
    }

    @Override
    public String getStatus() {
        return this.spider.getStatus().name();
    }

    @Override
    public int getThread() {
        return this.spider.getThreadAlive();
    }

    @Override
    public void start() {
        this.spider.start();
    }

    @Override
    public void stop() {
        this.spider.stop();
    }

    @Override
    public Date getStartTime() {
        return this.spider.getStartTime();
    }

    @Override
    public int getPagePerSecond() {
        int runSeconds = (int)(System.currentTimeMillis() - this.getStartTime().getTime()) / 1000;
        return this.getSuccessPageCount() / runSeconds;
    }
}

