/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.aop.Invocation;
import vip.justlive.oxygen.aop.annotation.Aspect;
import vip.justlive.oxygen.cache.annotation.Cacheable;
import vip.justlive.oxygen.cache.generator.ArgsKeyGenerator;
import vip.justlive.oxygen.cache.generator.DefaultKeyGenerator;
import vip.justlive.oxygen.core.cache.Cache;
import vip.justlive.oxygen.core.cache.LocalCacheImpl;
import vip.justlive.oxygen.ioc.annotation.Bean;

@Bean
public class CacheAspect {
    static final Cache CACHE = new LocalCacheImpl("Aspect-Cache");
    private final DefaultKeyGenerator defaultKeyGenerator;
    private final ArgsKeyGenerator argsKeyGenerator;

    @Aspect(annotation=Cacheable.class, type={Aspect.TYPE.BEFORE})
    public boolean cacheRead(Invocation invocation) {
        Ctx ctx = this.parse(invocation);
        Cache cache = Cache.cache((String)ctx.cacheName);
        Object obj = cache.get(ctx.key);
        if (obj != null) {
            invocation.setReturnValue(obj);
            return false;
        }
        return true;
    }

    @Aspect(annotation=Cacheable.class, type={Aspect.TYPE.AFTER})
    public boolean cacheWrite(Invocation invocation) {
        Ctx ctx = this.parse(invocation);
        Object obj = Cache.cache((String)ctx.cacheName).get(ctx.key);
        if (!Objects.equals(obj, invocation.getReturnValue())) {
            if (ctx.duration > 0L) {
                Cache.cache((String)ctx.cacheName).set(ctx.key, invocation.getReturnValue(), ctx.duration, ctx.unit);
            } else {
                Cache.cache((String)ctx.cacheName).set(ctx.key, invocation.getReturnValue());
            }
        }
        return true;
    }

    private Ctx parse(Invocation invocation) {
        String key;
        String cacheKey = String.join((CharSequence)":", invocation.getTarget().getClass().getName(), invocation.getMethod().getName(), Arrays.deepToString(invocation.getArgs()));
        Ctx ctx = (Ctx)CACHE.get(cacheKey, Ctx.class);
        if (ctx != null) {
            return ctx;
        }
        ctx = new Ctx();
        Cacheable cacheable = invocation.getMethod().getAnnotation(Cacheable.class);
        String cacheName = cacheable.value();
        if (cacheName.length() == 0) {
            cacheName = Cache.class.getSimpleName();
        }
        key = (key = cacheable.key()).length() == 0 ? this.defaultKeyGenerator.generate(invocation.getTarget(), invocation.getMethod(), invocation.getArgs()).toString() : this.argsKeyGenerator.generate(invocation.getTarget(), invocation.getMethod(), key, invocation.getArgs()).toString();
        ctx.cacheName = cacheName;
        ctx.key = key;
        ctx.duration = cacheable.duration();
        ctx.unit = cacheable.timeUnit();
        CACHE.set(cacheKey, (Object)ctx, 10L, TimeUnit.MINUTES);
        return ctx;
    }

    public CacheAspect(DefaultKeyGenerator defaultKeyGenerator, ArgsKeyGenerator argsKeyGenerator) {
        this.defaultKeyGenerator = defaultKeyGenerator;
        this.argsKeyGenerator = argsKeyGenerator;
    }

    static class Ctx {
        String key;
        String cacheName;
        long duration;
        TimeUnit unit;

        Ctx() {
        }

        public String toString() {
            return "CacheAspect.Ctx(key=" + this.key + ", cacheName=" + this.cacheName + ", duration=" + this.duration + ", unit=" + (Object)((Object)this.unit) + ")";
        }
    }
}

